/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import com.jetbrains.python.refactoring.changeSignature.PyParameterInfo;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyChangeSignatureQuickFix
implements LocalQuickFix {
    private final boolean myOverridenMethod;

    public PyChangeSignatureQuickFix(boolean overriddenMethod) {
        this.myOverridenMethod = overriddenMethod;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.change.signature", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PyFunction complementaryMethod;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyChangeSignatureQuickFix", "applyFix"));
        }
        final PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PyFunction.class);
        if (function == null) {
            return;
        }
        PyClass cls = function.getContainingClass();
        assert (cls != null);
        String functionName = function.getName();
        String complementaryName = "__new__".equals(functionName) ? "__init__" : "__new__";
        PyFunction pyFunction = complementaryMethod = this.myOverridenMethod ? (PyFunction)PySuperMethodsSearch.search(function).findFirst() : cls.findMethodByName(complementaryName, true);
        assert (complementaryMethod != null);
        PyMethodDescriptor methodDescriptor = new PyMethodDescriptor(function){

            @Override
            public List<PyParameterInfo> getParameters() {
                List<PyParameterInfo> parameterInfos = super.getParameters();
                int paramLength = function.getParameterList().getParameters().length;
                int complementaryParamLength = complementaryMethod.getParameterList().getParameters().length;
                if (complementaryParamLength > paramLength) {
                    parameterInfos.add(new PyParameterInfo(-1, "**kwargs", "", false));
                }
                return parameterInfos;
            }
        };
        PyChangeSignatureDialog dialog = new PyChangeSignatureDialog(project, methodDescriptor);
        dialog.show();
    }
}

