/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyAddSpecifierToFormatQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.specifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyAddSpecifierToFormatQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyAddSpecifierToFormatQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyAddSpecifierToFormatQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyAddSpecifierToFormatQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyBinaryExpression expression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyBinaryExpression.class);
        if (expression == null) {
            return;
        }
        PyExpression rightExpression = expression.getRightExpression();
        if (rightExpression instanceof PyParenthesizedExpression) {
            rightExpression = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
        }
        if (rightExpression == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
        if (document == null) {
            return;
        }
        int offset = element.getTextOffset();
        TypeEvalContext context = TypeEvalContext.userInitiated(file.getProject(), file);
        PyClassType strType = PyBuiltinCache.getInstance(element).getStrType();
        PyClassType floatType = PyBuiltinCache.getInstance(element).getFloatType();
        PyClassType intType = PyBuiltinCache.getInstance(element).getIntType();
        PyExpression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof PyStringLiteralExpression) {
            List<PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(((PyStringLiteralExpression)leftExpression).getStringValue()));
            PyExpression[] elements = rightExpression instanceof PyTupleExpression ? ((PyTupleExpression)rightExpression).getElements() : new PyExpression[]{rightExpression};
            int shift = 2;
            for (int i = 0; i < chunks.size(); ++i) {
                PyStringFormatParser.SubstitutionChunk chunk = chunks.get(i);
                if (elements.length <= i) {
                    return;
                }
                PyType type = context.getType(elements[i]);
                char conversionType = chunk.getConversionType();
                if (conversionType != '\u0000') continue;
                int insertOffset = offset + chunk.getStartIndex() + shift;
                if (insertOffset > leftExpression.getTextRange().getEndOffset()) {
                    return;
                }
                if (PyTypeChecker.match(strType, type, context)) {
                    document.insertString(insertOffset, (CharSequence)"s");
                    ++shift;
                }
                if (!PyTypeChecker.match(intType, type, context) && !PyTypeChecker.match(floatType, type, context)) continue;
                document.insertString(insertOffset, (CharSequence)"d");
                ++shift;
            }
        }
    }
}

