/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PyAddPropertyForFieldQuickFix
implements LocalQuickFix {
    private String myName = PyBundle.message("QFIX.add.property", new Object[0]);

    public PyAddPropertyForFieldQuickFix(String name) {
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyAddPropertyForFieldQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PyReferenceExpression) {
            PyTargetExpression target;
            PyClass containingClass;
            PsiReference reference = element.getReference();
            if (reference == null) {
                return;
            }
            PsiElement resolved = reference.resolve();
            if (resolved instanceof PyTargetExpression && (containingClass = (target = (PyTargetExpression)resolved).getContainingClass()) != null) {
                PyExpression qualifier;
                String name = target.getName();
                if (name == null) {
                    return;
                }
                String propertyName = StringUtil.trimStart((String)name, (String)"_");
                Map<String, Property> properties = containingClass.getProperties();
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                if (!properties.containsKey(propertyName)) {
                    PyFunction property = generator.createProperty(LanguageLevel.forElement(containingClass), propertyName, name, AccessDirection.READ);
                    PyUtil.addElementToStatementList(property, containingClass.getStatementList(), false);
                }
                if ((qualifier = ((PyReferenceExpression)element).getQualifier()) != null) {
                    String newElementText = qualifier.getText() + "." + propertyName;
                    PyExpression newElement = generator.createExpressionFromText(LanguageLevel.forElement(containingClass), newElementText);
                    element.replace((PsiElement)newElement);
                }
            }
        }
    }
}

