/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import org.jetbrains.annotations.NotNull;

public class PyAddExceptionSuperClassQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.exception.base", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyAddExceptionSuperClassQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/PyAddExceptionSuperClassQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiPolyVariantReference reference;
        PsiElement psiElement;
        PyExpression callee;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/PyAddExceptionSuperClassQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/PyAddExceptionSuperClassQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PyCallExpression && (callee = ((PyCallExpression)element).getCallee()) instanceof PyReferenceExpression && (psiElement = (reference = ((PyReferenceExpression)callee).getReference()).resolve()) instanceof PyClass) {
            PyElementGenerator generator = PyElementGenerator.getInstance(project);
            PyArgumentList list = ((PyClass)psiElement).getSuperClassExpressionList();
            if (list != null) {
                PyExpression exception = generator.createExpressionFromText(LanguageLevel.forElement(element), "Exception");
                list.addArgument(exception);
            } else {
                PyArgumentList expressionList = generator.createFromText(LanguageLevel.forElement(element), PyClass.class, "class A(Exception): pass").getSuperClassExpressionList();
                assert (expressionList != null);
                ASTNode nameNode = ((PyClass)psiElement).getNameNode();
                assert (nameNode != null);
                psiElement.addAfter((PsiElement)expressionList, nameNode.getPsi());
            }
        }
    }
}

