/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListCreationQuickFix
implements LocalQuickFix {
    private final PyAssignmentStatement myStatement;
    private final List<PyExpressionStatement> myStatements = new ArrayList<PyExpressionStatement>();

    public ListCreationQuickFix(PyAssignmentStatement statement) {
        this.myStatement = statement;
    }

    public void addStatement(PyExpressionStatement statement) {
        this.myStatements.add(statement);
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.list.creation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix", "applyFix"));
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        StringBuilder stringBuilder = new StringBuilder();
        PyExpression assignedValue = this.myStatement.getAssignedValue();
        if (assignedValue == null) {
            return;
        }
        for (PyExpression expression : ((PyListLiteralExpression)assignedValue).getElements()) {
            stringBuilder.append(expression.getText()).append(", ");
        }
        for (PyExpressionStatement statement : this.myStatements) {
            for (PyExpression expr : ((PyCallExpression)statement.getExpression()).getArguments()) {
                stringBuilder.append(expr.getText()).append(", ");
            }
            statement.delete();
        }
        assignedValue.replace((PsiElement)elementGenerator.createExpressionFromText("[" + stringBuilder.substring(0, stringBuilder.length() - 2) + "]"));
    }
}

