/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateBinaryStubsFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)("#" + GenerateBinaryStubsFix.class.getName()));
    private final String myQualifiedName;
    private final Sdk mySdk;

    @NotNull
    public static Collection<GenerateBinaryStubsFix> generateFixes(@NotNull PyImportStatementBase importStatementBase) {
        QualifiedName qName;
        if (importStatementBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatementBase", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "generateFixes"));
        }
        List<String> names = importStatementBase.getFullyQualifiedObjectNames();
        ArrayList<GenerateBinaryStubsFix> result = new ArrayList<GenerateBinaryStubsFix>(names.size());
        if (importStatementBase instanceof PyFromImportStatement && names.isEmpty() && (qName = ((PyFromImportStatement)importStatementBase).getImportSourceQName()) != null) {
            result.add(new GenerateBinaryStubsFix(importStatementBase, qName.toString()));
        }
        for (String qualifiedName : names) {
            result.add(new GenerateBinaryStubsFix(importStatementBase, qualifiedName));
        }
        ArrayList<GenerateBinaryStubsFix> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "generateFixes"));
        }
        return arrayList;
    }

    private GenerateBinaryStubsFix(@NotNull PyImportStatementBase importStatementBase, @NotNull String qualifiedName) {
        if (importStatementBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatementBase", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "<init>"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "<init>"));
        }
        this.myQualifiedName = qualifiedName;
        this.mySdk = GenerateBinaryStubsFix.getPythonSdk((PsiElement)importStatementBase);
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("sdk.gen.stubs.for.binary.modules", this.myQualifiedName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Generate binary stubs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "getFamilyName"));
        }
        return "Generate binary stubs";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "applyFix"));
        }
        PsiFile file = descriptor.getPsiElement().getContainingFile();
        Task.Backgroundable backgroundable = this.getFixTask(file);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(backgroundable, (ProgressIndicator)new BackgroundableProcessIndicator(backgroundable));
    }

    @NotNull
    public Task.Backgroundable getFixTask(final @NotNull PsiFile fileToRunTaskIn) {
        if (fileToRunTaskIn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToRunTaskIn", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "getFixTask"));
        }
        final Project project = fileToRunTaskIn.getProject();
        final String folder = fileToRunTaskIn.getContainingDirectory().getVirtualFile().getCanonicalPath();
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, "Generating skeletons for binary module", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix$1", "run"));
                }
                indicator.setIndeterminate(true);
                List assemblyRefs = (List)new ReadAction<List<String>>(){

                    protected void run(@NotNull Result<List<String>> result) throws Throwable {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix$1$1", "run"));
                        }
                        result.setResult((Object)GenerateBinaryStubsFix.this.collectAssemblyReferences(fileToRunTaskIn));
                    }
                }.execute().getResultObject();
                try {
                    VirtualFile skeletonDir;
                    PySkeletonRefresher refresher = new PySkeletonRefresher(project, null, GenerateBinaryStubsFix.this.mySdk, null, null, folder);
                    if (GenerateBinaryStubsFix.needBinaryList(GenerateBinaryStubsFix.this.myQualifiedName)) {
                        if (!GenerateBinaryStubsFix.this.generateSkeletonsForList(refresher, indicator, folder)) {
                            return;
                        }
                    } else {
                        refresher.generateSkeleton(GenerateBinaryStubsFix.this.myQualifiedName, "", assemblyRefs, (Consumer<Boolean>)Consumer.EMPTY_CONSUMER);
                    }
                    if ((skeletonDir = LocalFileSystem.getInstance().findFileByPath(refresher.getSkeletonsPath())) != null) {
                        skeletonDir.refresh(true, true);
                    }
                }
                catch (InvalidSdkException e) {
                    LOG.error((Throwable)e);
                }
            }
        };
        if (backgroundable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "getFixTask"));
        }
        return backgroundable;
    }

    private boolean generateSkeletonsForList(@NotNull PySkeletonRefresher refresher, ProgressIndicator indicator, @Nullable String currentBinaryFilesPath) throws InvalidSdkException {
        if (refresher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refresher", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "generateSkeletonsForList"));
        }
        PySkeletonGenerator generator = new PySkeletonGenerator(refresher.getSkeletonsPath(), this.mySdk, currentBinaryFilesPath);
        indicator.setIndeterminate(false);
        String homePath = this.mySdk.getHomePath();
        if (homePath == null) {
            return false;
        }
        ProcessOutput runResult = PySdkUtil.getProcessOutput(new File(homePath).getParent(), new String[]{homePath, PythonHelpersLocator.getHelperPath("extra_syspath.py"), this.myQualifiedName}, PythonSdkType.getVirtualEnvExtraEnv(homePath), 5000);
        if (runResult.getExitCode() == 0 && !runResult.isTimeout()) {
            String extraPath = runResult.getStdout();
            PySkeletonGenerator.ListBinariesResult binaries = generator.listBinaries(this.mySdk, extraPath);
            ArrayList names = Lists.newArrayList(binaries.modules.keySet());
            Collections.sort(names);
            int size = names.size();
            for (int i = 0; i != size; ++i) {
                String name = (String)names.get(i);
                indicator.setFraction((double)i / (double)size);
                if (!GenerateBinaryStubsFix.needBinaryList(name)) continue;
                indicator.setText2(name);
                PySkeletonRefresher.PyBinaryItem item = binaries.modules.get(name);
                String modulePath = item != null ? item.getPath() : "";
                refresher.generateSkeleton(name, modulePath, new ArrayList<String>(), (Consumer<Boolean>)Consumer.EMPTY_CONSUMER);
            }
        }
        return true;
    }

    private static boolean needBinaryList(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "needBinaryList"));
        }
        return qualifiedName.startsWith("gi.repository");
    }

    private List<String> collectAssemblyReferences(PsiFile file) {
        if (!(PythonSdkFlavor.getFlavor(this.mySdk) instanceof IronPythonSdkFlavor)) {
            return Collections.emptyList();
        }
        final ArrayList<String> result = new ArrayList<String>();
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                PyExpression[] args;
                super.visitPyCallExpression(node);
                if (node.isCalleeText("AddReference", "AddReferenceByPartialName", "AddReferenceByName") && (args = node.getArguments()).length == 1 && args[0] instanceof PyStringLiteralExpression) {
                    result.add(((PyStringLiteralExpression)args[0]).getStringValue());
                }
            }
        });
        return result;
    }

    public static boolean isApplicable(@NotNull PyImportStatementBase importStatementBase) {
        if (importStatementBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatementBase", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "isApplicable"));
        }
        if (!(!importStatementBase.getFullyQualifiedObjectNames().isEmpty() || importStatementBase instanceof PyFromImportStatement && ((PyFromImportStatement)importStatementBase).isStarImport())) {
            return false;
        }
        Sdk sdk = GenerateBinaryStubsFix.getPythonSdk((PsiElement)importStatementBase);
        if (sdk == null) {
            return false;
        }
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
        if (flavor instanceof IronPythonSdkFlavor) {
            return true;
        }
        return GenerateBinaryStubsFix.isGtk(importStatementBase);
    }

    private static boolean isGtk(@NotNull PyImportStatementBase importStatementBase) {
        QualifiedName qName;
        if (importStatementBase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatementBase", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "isGtk"));
        }
        return importStatementBase instanceof PyFromImportStatement && (qName = ((PyFromImportStatement)importStatementBase).getImportSourceQName()) != null && qName.matches(new String[]{"gi", "repository"});
    }

    @Nullable
    private static Sdk getPythonSdk(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/GenerateBinaryStubsFix", "getPythonSdk"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        return module == null ? null : PythonSdkType.findPythonSdk(module);
    }
}

