/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyGenerateDocstringIntention;
import com.jetbrains.python.documentation.PyDocstringGenerator;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.editor.PythonDocCommentUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocstringQuickFix
implements LocalQuickFix {
    String myMissingText;
    String myUnexpected;
    String myPrefix;

    public DocstringQuickFix(String missing, String unexpected) {
        this.myMissingText = missing;
        this.myUnexpected = unexpected;
    }

    @NotNull
    public String getName() {
        if (this.myMissingText != null) {
            String string = PyBundle.message("QFIX.docstring.add.$0", this.myMissingText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/DocstringQuickFix", "getName"));
            }
            return string;
        }
        if (this.myUnexpected != null) {
            String string = PyBundle.message("QFIX.docstring.remove.$0", this.myUnexpected);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/DocstringQuickFix", "getName"));
            }
            return string;
        }
        String string = PyBundle.message("QFIX.docstring.insert.stub", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/DocstringQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Fix docstring" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/DocstringQuickFix", "getFamilyName"));
        }
        return "Fix docstring";
    }

    @Nullable
    private static Editor getEditor(Project project, PsiFile file) {
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document != null) {
            EditorFactory instance = EditorFactory.getInstance();
            if (instance == null) {
                return null;
            }
            Editor[] editors = instance.getEditors(document);
            if (editors.length > 0) {
                return editors[0];
            }
        }
        return null;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/DocstringQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/DocstringQuickFix", "applyFix"));
        }
        PyDocStringOwner docStringOwner = (PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PyDocStringOwner.class);
        if (docStringOwner == null) {
            return;
        }
        PyStringLiteralExpression docStringExpression = docStringOwner.getDocStringExpression();
        if (docStringExpression == null && this.myMissingText == null && this.myUnexpected == null) {
            DocstringQuickFix.addEmptyDocstring(project, docStringOwner);
            return;
        }
        if (docStringExpression != null) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)docStringExpression);
            if (module == null) {
                return;
            }
            PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
            this.myPrefix = documentationSettings.isEpydocFormat(docStringExpression.getContainingFile()) ? "@" : ":";
            String replacement = docStringExpression.getText();
            if (this.myMissingText != null) {
                replacement = this.createMissingReplacement(docStringOwner);
            }
            if (this.myUnexpected != null) {
                replacement = PythonDocCommentUtil.removeParamFromDocstring(replacement, this.myPrefix, this.myUnexpected);
            }
            if (!replacement.equals(docStringExpression.getText()) && !StringUtil.isEmptyOrSpaces((String)replacement)) {
                PyExpression str = elementGenerator.createDocstring(replacement).getExpression();
                docStringExpression.replace((PsiElement)str);
            }
        }
    }

    private static void addEmptyDocstring(Project project, PyDocStringOwner docStringOwner) {
        if (docStringOwner instanceof PyFunction) {
            PyGenerateDocstringIntention.generateDocstringForFunction(project, DocstringQuickFix.getEditor(project, docStringOwner.getContainingFile()), (PyFunction)docStringOwner);
        }
        if (docStringOwner instanceof PyClass) {
            PyFunction init = ((PyClass)docStringOwner).findInitOrNew(false);
            if (init == null) {
                return;
            }
            PythonDocumentationProvider.insertDocStub(init, ((PyClass)docStringOwner).getStatementList(), project, DocstringQuickFix.getEditor(project, docStringOwner.getContainingFile()));
        }
    }

    private String createMissingReplacement(PyDocStringOwner docStringOwner) {
        return new PyDocstringGenerator(docStringOwner).withParam("param", this.myMissingText).docStringAsText();
    }
}

