/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyDictCreationInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DictCreationQuickFix
implements LocalQuickFix {
    private final PyAssignmentStatement myStatement;

    public DictCreationQuickFix(@NotNull PyAssignmentStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix", "<init>"));
        }
        this.myStatement = statement;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.dict.creation", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/DictCreationQuickFix", "applyFix"));
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        LinkedHashMap statementsMap = Maps.newLinkedHashMap();
        PyExpression assignedValue = this.myStatement.getAssignedValue();
        if (assignedValue instanceof PyDictLiteralExpression) {
            for (PyKeyValueExpression expression : ((PyDictLiteralExpression)assignedValue).getElements()) {
                PyExpression value = expression.getValue();
                if (value == null) continue;
                statementsMap.put(expression.getKey().getText(), value.getText());
            }
            PyStatement statement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.myStatement, PyStatement.class);
            while (statement instanceof PyAssignmentStatement) {
                PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)statement;
                PyExpression target = this.myStatement.getTargets()[0];
                String targetName = target.getName();
                if (targetName == null) continue;
                List<Pair<PyExpression, PyExpression>> targetsToValues = PyDictCreationInspection.getDictTargets(target, targetName, assignmentStatement);
                PyStatement nextStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement, PyStatement.class);
                if (targetsToValues == null || targetsToValues.isEmpty()) break;
                for (Pair<PyExpression, PyExpression> targetToValue : targetsToValues) {
                    PySubscriptionExpression subscription = (PySubscriptionExpression)targetToValue.first;
                    PyExpression indexExpression = subscription.getIndexExpression();
                    assert (indexExpression != null);
                    String indexText = indexExpression instanceof PyTupleExpression ? "(" + indexExpression.getText() + ")" : indexExpression.getText();
                    String valueText = targetToValue.second instanceof PyTupleExpression ? "(" + ((PyExpression)targetToValue.second).getText() + ")" : ((PyExpression)targetToValue.second).getText();
                    statementsMap.put(indexText, valueText);
                    statement.delete();
                }
                statement = nextStatement;
            }
            ArrayList statements = Lists.newArrayList();
            for (Map.Entry entry : statementsMap.entrySet()) {
                statements.add((String)entry.getKey() + ": " + (String)entry.getValue());
            }
            PyExpression expression = elementGenerator.createExpressionFromText(LanguageLevel.forElement(this.myStatement), "{" + StringUtil.join((Collection)statements, (String)", ") + "}");
            if (expression != null) {
                assignedValue.replace((PsiElement)expression);
            }
        }
    }
}

