/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import org.jetbrains.annotations.NotNull;

public class CreateClassQuickFix
implements LocalQuickFix {
    private final String myClassName;
    private final PsiElement myAnchor;

    public CreateClassQuickFix(String className, PsiElement anchor) {
        this.myClassName = className;
        this.myAnchor = anchor;
    }

    @NotNull
    public String getName() {
        if (this.myAnchor instanceof PyFile) {
            String string = "Create class '" + this.myClassName + "' in module " + ((PyFile)this.myAnchor).getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix", "getName"));
            }
            return string;
        }
        String string = "Create class '" + this.myClassName + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create Class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix", "getFamilyName"));
        }
        return "Create Class";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/CreateClassQuickFix", "applyFix"));
        }
        PsiElement anchor = this.myAnchor;
        if (!anchor.isValid()) {
            return;
        }
        if (!(anchor instanceof PyFile)) {
            while (!(anchor.getParent() instanceof PyFile)) {
                anchor = anchor.getParent();
            }
        }
        PyClass pyClass = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyClass.class, "class " + this.myClassName + "(object):\n    pass");
        pyClass = anchor instanceof PyFile ? (PyClass)anchor.add((PsiElement)pyClass) : (PyClass)anchor.getParent().addBefore((PsiElement)pyClass, anchor);
        pyClass = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(pyClass);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)pyClass);
        builder.replaceElement((PsiElement)pyClass.getSuperClassExpressions()[0], "object");
        builder.replaceElement((PsiElement)pyClass.getStatementList(), "pass");
        builder.run();
    }
}

