/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStatement;
import org.jetbrains.annotations.NotNull;

public class ConvertSetLiteralQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("INTN.convert.set.literal.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertSetLiteralQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.Family.convert.set.literal", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertSetLiteralQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ConvertSetLiteralQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ConvertSetLiteralQuickFix", "applyFix"));
        }
        PsiElement setLiteral = descriptor.getPsiElement();
        if (setLiteral instanceof PySetLiteralExpression) {
            PyExpression[] expressions = ((PySetLiteralExpression)setLiteral).getElements();
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            assert (expressions.length != 0);
            StringBuilder stringBuilder = new StringBuilder(expressions[0].getText());
            for (int i = 1; i < expressions.length; ++i) {
                stringBuilder.append(", ");
                stringBuilder.append(expressions[i].getText());
            }
            PyStatement newElement = elementGenerator.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, "set([" + stringBuilder.toString() + "])");
            setLiteral.replace((PsiElement)newElement);
        }
    }
}

