/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actions.ConvertIndentsActionBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class ConvertIndentsFix
implements LocalQuickFix {
    private final boolean myToSpaces;

    public ConvertIndentsFix(boolean toSpaces) {
        this.myToSpaces = toSpaces;
    }

    @NotNull
    public String getName() {
        String string = this.myToSpaces ? "Convert indents to spaces" : "Convert indents to tabs";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Convert indents" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix", "getFamilyName"));
        }
        return "Convert indents";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ConvertIndentsFix", "applyFix"));
        }
        PsiFile file = descriptor.getPsiElement().getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document != null) {
            int tabSize = CodeStyleFacade.getInstance((Project)project).getIndentSize(file.getFileType());
            TextRange allDoc = new TextRange(0, document.getTextLength());
            if (this.myToSpaces) {
                ConvertIndentsActionBase.convertIndentsToSpaces(document, tabSize, allDoc);
            } else {
                ConvertIndentsActionBase.convertIndentsToTabs(document, tabSize, allDoc);
            }
        }
    }
}

