/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import org.jetbrains.annotations.NotNull;

public class ConvertDocstringQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.convert.single.quoted.docstring", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix", "applyFix"));
        }
        PsiElement expression = descriptor.getPsiElement();
        if (expression instanceof PyStringLiteralExpression && expression.isWritable()) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            String stringText = expression.getText();
            int prefixLength = PyStringLiteralExpressionImpl.getPrefixLength(stringText);
            String prefix = stringText.substring(0, prefixLength);
            String content = stringText.substring(prefixLength);
            if (content.startsWith("'''")) {
                content = content.substring(3, content.length() - 3);
            } else {
                if (content.startsWith("\"\"\"")) {
                    return;
                }
                String string = content = content.length() == 1 ? "" : content.substring(1, content.length() - 1);
            }
            if (content.endsWith("\"")) {
                content = StringUtil.replaceSubstring((String)content, (TextRange)TextRange.create((int)(content.length() - 1), (int)content.length()), (String)"\\\"");
            }
            PyExpression newString = elementGenerator.createDocstring(prefix + "\"\"\"" + content + "\"\"\"").getExpression();
            expression.replace((PsiElement)newString);
        }
    }
}

