/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.ComprehensionComponent;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.ComprhIfComponent;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertDictCompQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("INTN.convert.dict.comp.to", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertDictCompQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.Family.convert.dict.comp.expression", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ConvertDictCompQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ConvertDictCompQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ConvertDictCompQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (!LanguageLevel.forElement(element).isPy3K() && element instanceof PyDictCompExpression) {
            ConvertDictCompQuickFix.replaceComprehension(project, (PyDictCompExpression)element);
        }
    }

    private static void replaceComprehension(Project project, PyDictCompExpression expression) {
        if (expression.getResultExpression() instanceof PyKeyValueExpression) {
            PyKeyValueExpression keyValueExpression = (PyKeyValueExpression)expression.getResultExpression();
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            assert (keyValueExpression.getValue() != null);
            List<ComprehensionComponent> components = expression.getComponents();
            StringBuilder replacement = new StringBuilder("dict([(" + keyValueExpression.getKey().getText() + ", " + keyValueExpression.getValue().getText() + ")");
            int slashNum = 1;
            for (ComprehensionComponent component : components) {
                PyExpression test;
                if (component instanceof ComprhForComponent) {
                    replacement.append("for ");
                    replacement.append(((ComprhForComponent)component).getIteratorVariable().getText());
                    replacement.append(" in ");
                    replacement.append(((ComprhForComponent)component).getIteratedList().getText());
                    replacement.append(" ");
                }
                if (component instanceof ComprhIfComponent && (test = ((ComprhIfComponent)component).getTest()) != null) {
                    replacement.append("if ");
                    replacement.append(test.getText());
                    replacement.append(" ");
                }
                for (int i = 0; i != slashNum; ++i) {
                    replacement.append("\t");
                }
                ++slashNum;
            }
            replacement.append("])");
            expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.getDefault(), PyExpressionStatement.class, replacement.toString()));
        }
    }
}

