/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import org.jetbrains.annotations.NotNull;

public class CompatibilityPrintCallQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.statement.effect", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/CompatibilityPrintCallQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/CompatibilityPrintCallQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/CompatibilityPrintCallQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/CompatibilityPrintCallQuickFix", "applyFix"));
        }
        PsiElement expression = descriptor.getPsiElement();
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        CompatibilityPrintCallQuickFix.replacePrint(expression, elementGenerator);
    }

    private static void replacePrint(PsiElement expression, PyElementGenerator elementGenerator) {
        StringBuilder stringBuilder = new StringBuilder("print(");
        PyFile file = (PyFile)expression.getContainingFile();
        Object[] target = (PyExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PyExpression.class);
        if (target != null) {
            stringBuilder.append(StringUtil.join((Object[])target, (Function)new Function<PyExpression, String>(){

                public String fun(PyExpression o) {
                    return o.getText();
                }
            }, (String)", "));
        }
        stringBuilder.append(")");
        expression.replace((PsiElement)elementGenerator.createFromText(LanguageLevel.forElement(expression), PyExpression.class, stringBuilder.toString()));
        PyFromImportStatement statement = elementGenerator.createFromText(LanguageLevel.forElement(expression), PyFromImportStatement.class, "from __future__ import print_function");
        file.addBefore((PsiElement)statement, (PsiElement)file.getStatements().get(0));
    }
}

