/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import org.jetbrains.annotations.NotNull;

public class ComparisonWithNoneQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.replace.equality", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ComparisonWithNoneQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ComparisonWithNoneQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ComparisonWithNoneQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ComparisonWithNoneQuickFix", "applyFix"));
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement instanceof PyBinaryExpression) {
            PyBinaryExpression binaryExpression = (PyBinaryExpression)problemElement;
            PyElementType operator = binaryExpression.getOperator();
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            String temp = operator == PyTokenTypes.EQEQ ? "is" : "is not";
            PyBinaryExpression expression = elementGenerator.createBinaryExpression(temp, binaryExpression.getLeftExpression(), binaryExpression.getRightExpression());
            binaryExpression.replace((PsiElement)expression);
        }
    }
}

