/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainedComparisonsQuickFix
implements LocalQuickFix {
    boolean myIsLeftLeft;
    boolean myIsRightLeft;
    boolean getInnerRight;

    public ChainedComparisonsQuickFix(boolean isLeft, boolean isRight, boolean getInner) {
        this.myIsLeftLeft = isLeft;
        this.myIsRightLeft = isRight;
        this.getInnerRight = getInner;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.chained.comparison", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/ChainedComparisonsQuickFix", "applyFix"));
        }
        PsiElement expression = descriptor.getPsiElement();
        if (expression != null && expression.isWritable() && expression instanceof PyBinaryExpression) {
            PyExpression leftExpression = ((PyBinaryExpression)expression).getLeftExpression();
            PyExpression rightExpression = ((PyBinaryExpression)expression).getRightExpression();
            if (rightExpression instanceof PyBinaryExpression && leftExpression instanceof PyBinaryExpression && ((PyBinaryExpression)expression).getOperator() == PyTokenTypes.AND_KEYWORD) {
                if (this.getInnerRight && ((PyBinaryExpression)leftExpression).getRightExpression() instanceof PyBinaryExpression && PyTokenTypes.AND_KEYWORD == ((PyBinaryExpression)leftExpression).getOperator()) {
                    leftExpression = ((PyBinaryExpression)leftExpression).getRightExpression();
                }
                this.checkOperator((PyBinaryExpression)leftExpression, (PyBinaryExpression)rightExpression, project);
            }
        }
    }

    private void checkOperator(PyBinaryExpression leftExpression, PyBinaryExpression rightExpression, Project project) {
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        if (this.myIsLeftLeft) {
            PyExpression newLeftExpression = this.invertExpression(leftExpression, elementGenerator);
            if (this.myIsRightLeft) {
                PsiElement operator = this.getLeftestOperator(rightExpression);
                PyBinaryExpression binaryExpression = elementGenerator.createBinaryExpression(operator.getText(), newLeftExpression, ChainedComparisonsQuickFix.getLargeRightExpression(rightExpression, project));
                leftExpression.replace((PsiElement)binaryExpression);
                rightExpression.delete();
            } else {
                String operator = this.invertOperator(rightExpression.getPsiOperator());
                PyBinaryExpression binaryExpression = elementGenerator.createBinaryExpression(operator, newLeftExpression, rightExpression.getLeftExpression());
                leftExpression.replace((PsiElement)binaryExpression);
                rightExpression.delete();
            }
        } else if (this.myIsRightLeft) {
            PsiElement operator = this.getLeftestOperator(rightExpression);
            PyBinaryExpression binaryExpression = elementGenerator.createBinaryExpression(operator.getText(), leftExpression, ChainedComparisonsQuickFix.getLargeRightExpression(rightExpression, project));
            leftExpression.replace((PsiElement)binaryExpression);
            rightExpression.delete();
        } else {
            PyExpression expression = rightExpression.getLeftExpression();
            if (expression instanceof PyBinaryExpression) {
                expression = this.invertExpression((PyBinaryExpression)expression, elementGenerator);
            }
            String operator = this.invertOperator(rightExpression.getPsiOperator());
            PyBinaryExpression binaryExpression = elementGenerator.createBinaryExpression(operator, leftExpression, expression);
            leftExpression.replace((PsiElement)binaryExpression);
            rightExpression.delete();
        }
    }

    private PsiElement getLeftestOperator(PyBinaryExpression expression) {
        PsiElement op = expression.getPsiOperator();
        while (expression.getLeftExpression() instanceof PyBinaryExpression) {
            expression = (PyBinaryExpression)expression.getLeftExpression();
            op = expression.getPsiOperator();
        }
        assert (op != null);
        return op;
    }

    private PyExpression invertExpression(PyBinaryExpression leftExpression, PyElementGenerator elementGenerator) {
        PsiElement operator = leftExpression.getPsiOperator();
        PyExpression right = leftExpression.getRightExpression();
        PyExpression left = leftExpression.getLeftExpression();
        if (left instanceof PyBinaryExpression) {
            left = this.invertExpression((PyBinaryExpression)left, elementGenerator);
        }
        String newOperator = this.invertOperator(operator);
        return elementGenerator.createBinaryExpression(newOperator, right, left);
    }

    private String invertOperator(PsiElement op) {
        if (op.getText().equals(">")) {
            return "<";
        }
        if (op.getText().equals("<")) {
            return ">";
        }
        if (op.getText().equals(">=")) {
            return "<=";
        }
        if (op.getText().equals("<=")) {
            return ">=";
        }
        return op.getText();
    }

    @Nullable
    private static PyExpression getLargeRightExpression(PyBinaryExpression expression, Project project) {
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpression left = expression.getLeftExpression();
        PyExpression right = expression.getRightExpression();
        PsiElement operator = expression.getPsiOperator();
        while (left instanceof PyBinaryExpression) {
            assert (operator != null);
            right = elementGenerator.createBinaryExpression(operator.getText(), ((PyBinaryExpression)left).getRightExpression(), right);
            operator = ((PyBinaryExpression)left).getPsiOperator();
            left = ((PyBinaryExpression)left).getLeftExpression();
        }
        return right;
    }
}

