/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AugmentedAssignmentQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.augment.assignment", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AugmentedAssignmentQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AugmentedAssignmentQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AugmentedAssignmentQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AugmentedAssignmentQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PyAssignmentStatement && element.isWritable()) {
            PyAssignmentStatement statement = (PyAssignmentStatement)element;
            PyExpression target = statement.getLeftHandSideExpression();
            PyBinaryExpression expression = (PyBinaryExpression)statement.getAssignedValue();
            if (expression == null) {
                return;
            }
            PyExpression leftExpression = expression.getLeftExpression();
            PyExpression rightExpression = expression.getRightExpression();
            if (rightExpression instanceof PyParenthesizedExpression) {
                rightExpression = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
            }
            if (target != null && rightExpression != null) {
                String targetText = target.getText();
                String rightText = rightExpression.getText();
                if (rightText.equals(targetText)) {
                    PyExpression tmp = rightExpression;
                    rightExpression = leftExpression;
                    leftExpression = tmp;
                }
                List comments = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)statement, PsiComment.class);
                if ((leftExpression instanceof PyReferenceExpression || leftExpression instanceof PySubscriptionExpression) && leftExpression.getText().equals(targetText)) {
                    PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                    StringBuilder stringBuilder = new StringBuilder();
                    PsiElement psiOperator = expression.getPsiOperator();
                    if (psiOperator == null) {
                        return;
                    }
                    stringBuilder.append(targetText).append(" ").append(psiOperator.getText()).append("= ").append(rightExpression.getText());
                    PyAugAssignmentStatementImpl augAssignment = elementGenerator.createFromText(LanguageLevel.forElement(element), PyAugAssignmentStatementImpl.class, stringBuilder.toString());
                    for (PsiComment comment : comments) {
                        augAssignment.add((PsiElement)comment);
                    }
                    statement.replace((PsiElement)augAssignment);
                }
            }
        }
    }
}

