/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddSelfQuickFix
implements LocalQuickFix {
    private final String myParamName;

    public AddSelfQuickFix(String paramName) {
        this.myParamName = paramName;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.add.parameter.self", this.myParamName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddSelfQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        if ("Add parameter" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddSelfQuickFix", "getFamilyName"));
        }
        return "Add parameter";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddSelfQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddSelfQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element instanceof PyParameterList) {
            PyParameterList parameterList = (PyParameterList)element;
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PyNamedParameter newParameter = PyElementGenerator.getInstance(project).createParameter(this.myParamName);
            parameterList.addParameter(newParameter);
        }
    }
}

