/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public class AddMethodQuickFix
implements LocalQuickFix {
    private final String myClassName;
    private final boolean myReplaceUsage;
    private String myIdentifier;

    public AddMethodQuickFix(String identifier, String className, boolean replaceUsage) {
        this.myIdentifier = identifier;
        this.myClassName = className;
        this.myReplaceUsage = replaceUsage;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.method.$0.to.class.$1", this.myIdentifier, this.myClassName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Add method to class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix", "getFamilyName"));
        }
        return "Add method to class";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix", "applyFix"));
        }
        try {
            PsiElement problemElement = descriptor.getPsiElement();
            PyClassType type = AddMethodQuickFix.getClassType(problemElement);
            if (type == null) {
                return;
            }
            PyClass cls = type.getPyClass();
            boolean callByClass = type.isDefinition();
            PyStatementList clsStmtList = cls.getStatementList();
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)clsStmtList));
            PyFunctionBuilder builder = new PyFunctionBuilder(this.myIdentifier);
            PsiElement pe = problemElement.getParent();
            String decoratorName = null;
            PyExpression[] args = new PyExpression[]{};
            if (pe instanceof PyCallExpression) {
                PyArgumentList arglist = ((PyCallExpression)pe).getArgumentList();
                if (arglist == null) {
                    return;
                }
                args = arglist.getArguments();
            }
            boolean madeInstance = false;
            if (callByClass) {
                PyType firstArgType;
                if (args.length > 0 && (firstArgType = TypeEvalContext.userInitiated(cls.getProject(), cls.getContainingFile()).getType(args[0])) instanceof PyClassType && ((PyClassType)firstArgType).getPyClass().isSubclass(cls)) {
                    builder.parameter("self");
                    madeInstance = true;
                }
                if (!madeInstance) {
                    builder.parameter("cls");
                    decoratorName = "classmethod";
                }
            } else {
                builder.parameter("self");
            }
            boolean skipFirst = callByClass && madeInstance;
            for (PyExpression arg : args) {
                if (skipFirst) {
                    skipFirst = false;
                    continue;
                }
                if (arg instanceof PyKeywordArgument) {
                    builder.parameter(((PyKeywordArgument)arg).getKeyword());
                    continue;
                }
                if (arg instanceof PyReferenceExpression) {
                    PyReferenceExpression refex = (PyReferenceExpression)arg;
                    builder.parameter(refex.getReferencedName());
                    continue;
                }
                builder.parameter("param");
            }
            PyFunction method = builder.buildFunction(project, LanguageLevel.getDefault());
            if (decoratorName != null) {
                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                PyDecoratorList decoratorList = generator.createFromText(LanguageLevel.getDefault(), PyDecoratorList.class, "@" + decoratorName + "\ndef foo(): pass", new int[]{0, 0});
                method.addBefore((PsiElement)decoratorList, method.getFirstChild());
            }
            method = (PyFunction)PyUtil.addElementToStatementList(method, clsStmtList, "__init__".equals(method.getName()));
            if (this.myReplaceUsage) {
                AddMethodQuickFix.showTemplateBuilder(method);
            }
        }
        catch (IncorrectOperationException ignored) {
            PyUtil.showBalloon(project, PyBundle.message("QFIX.failed.to.add.method", new Object[0]), MessageType.ERROR);
        }
    }

    private static PyClassType getClassType(@NotNull PsiElement problemElement) {
        if (problemElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemElement", "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix", "getClassType"));
        }
        if (problemElement instanceof PyQualifiedExpression) {
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier == null) {
                return null;
            }
            PyType type = TypeEvalContext.userInitiated(problemElement.getProject(), problemElement.getContainingFile()).getType(qualifier);
            return type instanceof PyClassType ? (PyClassType)type : null;
        }
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)problemElement, PyClass.class);
        return pyClass != null ? new PyClassTypeImpl(pyClass, false) : null;
    }

    private static void showTemplateBuilder(@NotNull PyFunction method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/jetbrains/python/inspections/quickfix/AddMethodQuickFix", "showTemplateBuilder"));
        }
        PsiFile file = (method = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(method)).getContainingFile();
        if (file == null) {
            return;
        }
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
        ParamHelper.walkDownParamArray(method.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        PyStatementList statementList = method.getStatementList();
        builder.replaceElement((PsiElement)statementList, "pass");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)file.getProject()).openTextEditor(new OpenFileDescriptor(file.getProject(), virtualFile), true);
        if (editor == null) {
            return;
        }
        builder.run(editor, false);
    }
}

