/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import org.jetbrains.annotations.NotNull;

public class AddIgnoredIdentifierQuickFix
implements LocalQuickFix,
LowPriorityAction {
    public static final String END_WILDCARD = ".*";
    @NotNull
    private final QualifiedName myIdentifier;
    private final boolean myIgnoreAllAttributes;

    public AddIgnoredIdentifierQuickFix(@NotNull QualifiedName identifier, boolean ignoreAllAttributes) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix", "<init>"));
        }
        this.myIdentifier = identifier;
        this.myIgnoreAllAttributes = ignoreAllAttributes;
    }

    @NotNull
    public String getName() {
        if (this.myIgnoreAllAttributes) {
            String string = "Mark all unresolved attributes of '" + this.myIdentifier + "' as ignored";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix", "getName"));
            }
            return string;
        }
        String string = "Ignore unresolved reference '" + this.myIdentifier + "'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Ignore unresolved reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix", "getFamilyName"));
        }
        return "Ignore unresolved reference";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix", "applyFix"));
        }
        final PsiElement context = descriptor.getPsiElement();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        profile.modifyProfile((Consumer)new Consumer<ModifiableModel>(){

            public void consume(ModifiableModel model) {
                PyUnresolvedReferencesInspection inspection = (PyUnresolvedReferencesInspection)model.getUnwrappedTool(PyUnresolvedReferencesInspection.class.getSimpleName(), context);
                String name = AddIgnoredIdentifierQuickFix.this.myIdentifier.toString();
                if (AddIgnoredIdentifierQuickFix.this.myIgnoreAllAttributes) {
                    name = name + AddIgnoredIdentifierQuickFix.END_WILDCARD;
                }
                if (!inspection.ignoredIdentifiers.contains(name)) {
                    inspection.ignoredIdentifiers.add(name);
                }
            }
        });
    }
}

