/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddGlobalQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.add.global", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddGlobalQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddGlobalQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddGlobalQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddGlobalQuickFix", "applyFix"));
        }
        PsiElement problemElt = descriptor.getPsiElement();
        if (problemElt instanceof PyReferenceExpression) {
            PyStatementList statementList;
            PyReferenceExpression expression = (PyReferenceExpression)problemElt;
            final String name = expression.getReferencedName();
            ScopeOwner owner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)problemElt, ScopeOwner.class);
            assert (owner instanceof PyClass || owner instanceof PyFunction) : "Add global quickfix is available only inside class or function, but applied for " + owner;
            final Ref added = new Ref((Object)false);
            owner.accept(new PyRecursiveElementVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (!((Boolean)added.get()).booleanValue()) {
                        super.visitElement(element);
                    }
                }

                @Override
                public void visitPyGlobalStatement(PyGlobalStatement node) {
                    if (!((Boolean)added.get()).booleanValue()) {
                        node.addGlobal(name);
                        added.set((Object)true);
                    }
                }
            });
            if (((Boolean)added.get()).booleanValue()) {
                return;
            }
            PyGlobalStatement globalStatement = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyGlobalStatement.class, "global " + name);
            boolean hasDocString = false;
            if (owner instanceof PyClass) {
                statementList = ((PyClass)owner).getStatementList();
                if (((PyClass)owner).getDocStringExpression() != null) {
                    hasDocString = true;
                }
            } else {
                statementList = ((PyFunction)owner).getStatementList();
                if (((PyFunction)owner).getDocStringExpression() != null) {
                    hasDocString = true;
                }
            }
            PyStatement first = statementList.getStatements()[0];
            if (hasDocString) {
                first = statementList.getStatements()[1];
            }
            statementList.addBefore(globalStatement, (PsiElement)first);
        }
    }
}

