/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddFunctionQuickFix
implements LocalQuickFix {
    private final String myIdentifier;
    private final String myModuleName;

    public AddFunctionQuickFix(@NotNull String identifier, String moduleName) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix", "<init>"));
        }
        this.myIdentifier = identifier;
        this.myModuleName = moduleName;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.function.$0.to.module.$1", this.myIdentifier, this.myModuleName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Create function in module" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix", "getFamilyName"));
        }
        return "Create function in module";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix", "applyFix"));
        }
        try {
            PsiElement problemElement = descriptor.getPsiElement();
            if (!(problemElement instanceof PyQualifiedExpression)) {
                return;
            }
            PyExpression qualifier = ((PyQualifiedExpression)problemElement).getQualifier();
            if (qualifier == null) {
                return;
            }
            PyType type = TypeEvalContext.userInitiated(problemElement.getProject(), problemElement.getContainingFile()).getType(qualifier);
            if (!(type instanceof PyModuleType)) {
                return;
            }
            PyFile file = ((PyModuleType)type).getModule();
            PyUtil.sure(file);
            PyUtil.sure(FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file));
            PyFunctionBuilder builder = new PyFunctionBuilder(this.myIdentifier);
            PsiElement problemParent = problemElement.getParent();
            if (problemParent instanceof PyCallExpression) {
                PyExpression[] args;
                PyArgumentList arglist = ((PyCallExpression)problemParent).getArgumentList();
                if (arglist == null) {
                    return;
                }
                for (PyExpression arg : args = arglist.getArguments()) {
                    if (arg instanceof PyKeywordArgument) {
                        builder.parameter(((PyKeywordArgument)arg).getKeyword());
                        continue;
                    }
                    if (arg instanceof PyReferenceExpression) {
                        PyReferenceExpression refex = (PyReferenceExpression)arg;
                        builder.parameter(refex.getReferencedName());
                        continue;
                    }
                    builder.parameter("param");
                }
            } else if (problemParent != null) {
                for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                    List<String> params = extension.getFunctionParametersFromUsage(problemElement);
                    if (params == null) continue;
                    for (String param : params) {
                        builder.parameter(param);
                    }
                    break;
                }
            }
            PyFunction function = builder.buildFunction(project, LanguageLevel.forElement(file));
            function = (PyFunction)file.add(function);
            AddFunctionQuickFix.showTemplateBuilder(function, file);
        }
        catch (IncorrectOperationException ignored) {
            PyUtil.showBalloon(project, PyBundle.message("QFIX.failed.to.add.function", new Object[0]), MessageType.ERROR);
        }
    }

    private static void showTemplateBuilder(PyFunction method, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/inspections/quickfix/AddFunctionQuickFix", "showTemplateBuilder"));
        }
        method = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(method);
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
        ParamHelper.walkDownParamArray(method.getParameterList().getParameters(), new ParamHelper.ParamVisitor(){

            @Override
            public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                builder.replaceElement((PsiElement)param, param.getName());
            }
        });
        builder.replaceElement((PsiElement)method.getStatementList(), "return None");
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)file.getProject()).openTextEditor(new OpenFileDescriptor(file.getProject(), virtualFile), true);
        if (editor == null) {
            return;
        }
        builder.run(editor, false);
    }
}

