/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFieldQuickFix
implements LocalQuickFix {
    private final String myInitializer;
    private final String myClassName;
    private String myIdentifier;
    private boolean replaceInitializer;

    public AddFieldQuickFix(@NotNull String identifier, @NotNull String initializer, String className, boolean replace) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "<init>"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "<init>"));
        }
        this.replaceInitializer = false;
        this.myIdentifier = identifier;
        this.myInitializer = initializer;
        this.myClassName = className;
        this.replaceInitializer = replace;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.NAME.add.field.$0.to.class.$1", this.myIdentifier, this.myClassName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Add field to class" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "getFamilyName"));
        }
        return "Add field to class";
    }

    @Nullable
    public static PsiElement appendToMethod(PyFunction init, Function<String, PyStatement> callback) {
        PyStatementList statementList = init.getStatementList();
        PyParameter[] params = init.getParameterList().getParameters();
        String selfName = "self";
        if (params.length > 0) {
            selfName = params[0].getName();
        }
        PyStatement newStmt = (PyStatement)callback.fun((Object)selfName);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)statementList)) {
            return null;
        }
        PsiElement result = PyUtil.addElementToStatementList((PsiElement)newStmt, statementList, true);
        PyPsiUtils.removeRedundantPass(statementList);
        return result;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement initStatement;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PyClassType type = AddFieldQuickFix.getClassType(element);
        if (type == null) {
            return;
        }
        PyClass cls = type.getPyClass();
        if (!type.isDefinition()) {
            initStatement = AddFieldQuickFix.addFieldToInit(project, cls, this.myIdentifier, new CreateFieldCallback(project, this.myIdentifier, this.myInitializer));
        } else {
            PyStatement field = PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyStatement.class, this.myIdentifier + " = " + this.myInitializer);
            initStatement = PyUtil.addElementToStatementList((PsiElement)field, cls.getStatementList(), true);
        }
        if (initStatement != null) {
            this.showTemplateBuilder(initStatement, cls.getContainingFile());
            return;
        }
        PyUtil.showBalloon(project, PyBundle.message("QFIX.failed.to.add.field", new Object[0]), MessageType.ERROR);
    }

    private static PyClassType getClassType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "getClassType"));
        }
        if (element instanceof PyQualifiedExpression) {
            PyExpression qualifier = ((PyQualifiedExpression)element).getQualifier();
            if (qualifier == null) {
                return null;
            }
            PyType type = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()).getType(qualifier);
            return type instanceof PyClassType ? (PyClassType)type : null;
        }
        PyClass aClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        return aClass != null ? new PyClassTypeImpl(aClass, false) : null;
    }

    private void showTemplateBuilder(PsiElement initStatement, @NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix", "showTemplateBuilder"));
        }
        if ((initStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(initStatement)) instanceof PyAssignmentStatement) {
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(initStatement);
            PyExpression assignedValue = ((PyAssignmentStatement)initStatement).getAssignedValue();
            PyExpression leftExpression = ((PyAssignmentStatement)initStatement).getLeftHandSideExpression();
            if (assignedValue != null && leftExpression != null) {
                if (this.replaceInitializer) {
                    builder.replaceElement((PsiElement)assignedValue, this.myInitializer);
                } else {
                    builder.replaceElement(leftExpression.getLastChild(), this.myIdentifier);
                }
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return;
                }
                Editor editor = FileEditorManager.getInstance((Project)file.getProject()).openTextEditor(new OpenFileDescriptor(file.getProject(), virtualFile), true);
                if (editor == null) {
                    return;
                }
                builder.run(editor, false);
            }
        }
    }

    @Nullable
    public static PsiElement addFieldToInit(Project project, PyClass cls, String itemName, Function<String, PyStatement> callback) {
        if (cls != null && itemName != null) {
            PyClass ancestor;
            PyFunction init = cls.findMethodByName("__init__", false);
            if (init != null) {
                return AddFieldQuickFix.appendToMethod(init, callback);
            }
            Iterator<PyClass> i$ = cls.getAncestorClasses().iterator();
            while (i$.hasNext() && (init = (ancestor = i$.next()).findMethodByName("__init__", false)) == null) {
            }
            PyFunction newInit = AddFieldQuickFix.createInitMethod(project, cls, init);
            if (newInit == null) {
                return null;
            }
            AddFieldQuickFix.appendToMethod(newInit, callback);
            PsiElement addAnchor = null;
            PyFunction[] meths = cls.getMethods(false);
            if (meths.length > 0) {
                addAnchor = meths[0].getPrevSibling();
            }
            PyStatementList clsContent = cls.getStatementList();
            newInit = (PyFunction)clsContent.addAfter(newInit, addAnchor);
            PyUtil.showBalloon(project, PyBundle.message("QFIX.added.constructor.$0.for.field.$1", cls.getName(), itemName), MessageType.INFO);
            PyStatementList statementList = newInit.getStatementList();
            PyStatement[] statements = statementList.getStatements();
            return statements.length != 0 ? statements[0] : null;
        }
        return null;
    }

    @Nullable
    private static PyFunction createInitMethod(Project project, PyClass cls, @Nullable PyFunction ancestorInit) {
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)cls)) {
            return null;
        }
        String paramList = ancestorInit != null ? ancestorInit.getParameterList().getText() : "(self)";
        String functionText = "def __init__" + paramList + ":\n";
        if (ancestorInit == null) {
            functionText = functionText + "    pass";
        } else {
            PyClass ancestorClass = ancestorInit.getContainingClass();
            if (ancestorClass != null && !PyUtil.isObjectClass(ancestorClass)) {
                StringBuilder sb = new StringBuilder();
                PyParameter[] params = ancestorInit.getParameterList().getParameters();
                boolean seen = false;
                if (cls.isNewStyleClass()) {
                    sb.append("super(");
                    if (!LanguageLevel.forElement(cls).isPy3K()) {
                        sb.append(cls.getName());
                        String self_name = params[0].getName();
                        sb.append(", ").append(self_name);
                    }
                    sb.append(").").append("__init__").append("(");
                } else {
                    sb.append(ancestorClass.getName());
                    sb.append(".__init__(self");
                    seen = true;
                }
                for (int i = 1; i < params.length; ++i) {
                    if (seen) {
                        sb.append(", ");
                    } else {
                        seen = true;
                    }
                    sb.append(params[i].getText());
                }
                sb.append(")");
                functionText = functionText + "    " + sb.toString();
            } else {
                functionText = functionText + "    pass";
            }
        }
        return PyElementGenerator.getInstance(project).createFromText(LanguageLevel.getDefault(), PyFunction.class, functionText, new int[]{0});
    }

    private static class CreateFieldCallback
    implements Function<String, PyStatement> {
        private Project myProject;
        private String myItemName;
        private String myInitializer;

        private CreateFieldCallback(Project project, String itemName, String initializer) {
            this.myProject = project;
            this.myItemName = itemName;
            this.myInitializer = initializer;
        }

        public PyStatement fun(String self_name) {
            return PyElementGenerator.getInstance(this.myProject).createFromText(LanguageLevel.getDefault(), PyStatement.class, self_name + "." + this.myItemName + " = " + this.myInitializer);
        }
    }
}

