/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AddEncodingQuickFix
implements LocalQuickFix {
    private final String myDefaultEncoding;
    private final int myEncodingFormatIndex;

    public AddEncodingQuickFix(String defaultEncoding, int encodingFormatIndex) {
        this.myDefaultEncoding = defaultEncoding;
        this.myEncodingFormatIndex = encodingFormatIndex;
    }

    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.add.encoding", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddEncodingQuickFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return;
        }
        PsiElement firstLine = file.getFirstChild();
        if (firstLine instanceof PsiComment && firstLine.getText().startsWith("#!")) {
            firstLine = firstLine.getNextSibling();
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        String commentText = String.format(PyEncodingUtil.ENCODING_FORMAT_PATTERN[this.myEncodingFormatIndex], this.myDefaultEncoding);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PsiComment encodingComment = elementGenerator.createFromText(languageLevel, PsiComment.class, commentText);
        encodingComment = (PsiComment)file.addBefore((PsiElement)encodingComment, firstLine);
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(element.getContainingFile().getVirtualFile());
        if (fileEditor instanceof TextEditor) {
            if (encodingComment.getNextSibling() == null || !encodingComment.getNextSibling().textContains('\n')) {
                file.addAfter((PsiElement)elementGenerator.createFromText(languageLevel, PsiWhiteSpace.class, "\n"), (PsiElement)encodingComment);
            }
            Editor editor = ((TextEditor)fileEditor).getEditor();
            Document document = editor.getDocument();
            int insertedLineNumber = document.getLineNumber(encodingComment.getTextOffset());
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(insertedLineNumber + 1, 0));
        }
    }
}

