/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddCallSuperQuickFix
implements LocalQuickFix {
    @NotNull
    public String getName() {
        String string = PyBundle.message("QFIX.add.super", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "getName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PyExpressionStatement st;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "applyFix"));
        }
        PyFunction problemFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PyFunction.class);
        if (problemFunction == null) {
            return;
        }
        StringBuilder superCall = new StringBuilder();
        PyClass klass = problemFunction.getContainingClass();
        if (klass == null) {
            return;
        }
        PyClass[] superClasses = klass.getSuperClasses();
        if (superClasses.length == 0) {
            return;
        }
        PyClass superClass = superClasses[0];
        PyFunction superInit = superClass.findMethodByName("__init__", true);
        if (superInit == null) {
            return;
        }
        boolean addComma = true;
        if (klass.isNewStyleClass()) {
            addComma = false;
            if (LanguageLevel.forElement(klass).isPy3K()) {
                superCall.append("super().__init__(");
            } else {
                superCall.append("super(").append(klass.getName()).append(", self).__init__(");
            }
        } else {
            superCall.append(superClass.getName());
            superCall.append(".__init__(self");
        }
        StringBuilder newFunction = new StringBuilder("def __init__(self");
        AddCallSuperQuickFix.buildParameterList(problemFunction, superInit, superCall, newFunction, addComma);
        superCall.append(")");
        PyStatementList statementList = problemFunction.getStatementList();
        PyExpression docstring = null;
        PyStatement[] statements = statementList.getStatements();
        if (statements.length != 0 && statements[0] instanceof PyExpressionStatement && (st = (PyExpressionStatement)statements[0]).getExpression() instanceof PyStringLiteralExpression) {
            docstring = st.getExpression();
        }
        newFunction.append("):\n\t");
        if (docstring != null) {
            newFunction.append(docstring.getText()).append("\n\t");
        }
        newFunction.append((CharSequence)superCall).append("\n\t");
        boolean first = true;
        for (PyStatement statement : statements) {
            if (first && docstring != null || statement instanceof PyPassStatement) {
                first = false;
                continue;
            }
            newFunction.append(statement.getText()).append("\n\t");
        }
        problemFunction.replace(PyElementGenerator.getInstance(project).createFromText(LanguageLevel.forElement(problemFunction), PyFunction.class, newFunction.toString()));
    }

    private static void buildParameterList(@NotNull PyFunction problemFunction, @NotNull PyFunction superInit, @NotNull StringBuilder superCall, @NotNull StringBuilder newFunction, boolean addComma) {
        if (problemFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemFunction", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "buildParameterList"));
        }
        if (superInit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superInit", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "buildParameterList"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "buildParameterList"));
        }
        if (newFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFunction", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "buildParameterList"));
        }
        PyParameter[] parameters = problemFunction.getParameterList().getParameters();
        ArrayList<String> problemParams = new ArrayList<String>();
        ArrayList<String> functionParams = new ArrayList<String>();
        String starName = null;
        String doubleStarName = null;
        for (int i = 1; i != parameters.length; ++i) {
            PyParameter p = parameters[i];
            functionParams.add(p.getName());
            if (p.getText().startsWith("**")) {
                doubleStarName = p.getText();
                continue;
            }
            if (p.getText().startsWith("*")) {
                starName = p.getText();
                continue;
            }
            if (p.getDefaultValue() != null) {
                problemParams.add(p.getText());
                continue;
            }
            newFunction.append(",").append(p.getText());
        }
        AddCallSuperQuickFix.addParametersFromSuper(superInit, superCall, newFunction, addComma, problemParams, functionParams, starName, doubleStarName);
    }

    private static void addParametersFromSuper(@NotNull PyFunction superInit, @NotNull StringBuilder superCall, @NotNull StringBuilder newFunction, boolean addComma, @NotNull List<String> problemParams, @NotNull List<String> functionParams, @Nullable String starName, @Nullable String doubleStarName) {
        if (superInit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superInit", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "addParametersFromSuper"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "addParametersFromSuper"));
        }
        if (newFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFunction", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "addParametersFromSuper"));
        }
        if (problemParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemParams", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "addParametersFromSuper"));
        }
        if (functionParams == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionParams", "com/jetbrains/python/inspections/quickfix/AddCallSuperQuickFix", "addParametersFromSuper"));
        }
        PyParameterList paramList = superInit.getParameterList();
        PyParameter[] parameters = paramList.getParameters();
        boolean addDouble = false;
        boolean addStar = false;
        for (int i = 1; i != parameters.length; ++i) {
            PyParameter pyParameter = parameters[i];
            if (pyParameter.getDefaultValue() != null) continue;
            String param = pyParameter.getName();
            String paramText = pyParameter.getText();
            if (paramText.startsWith("**")) {
                addDouble = true;
                if (doubleStarName != null) continue;
                doubleStarName = pyParameter.getText();
                continue;
            }
            if (paramText.startsWith("*")) {
                addStar = true;
                if (starName != null) continue;
                starName = pyParameter.getText();
                continue;
            }
            if (addComma) {
                superCall.append(",");
            }
            superCall.append(param);
            if (!functionParams.contains(param)) {
                newFunction.append(",").append(param);
            }
            addComma = true;
        }
        for (String string : problemParams) {
            newFunction.append(",").append(string);
        }
        if (starName != null) {
            newFunction.append(",").append(starName);
            if (addStar) {
                if (addComma) {
                    superCall.append(",");
                }
                superCall.append(starName);
                addComma = true;
            }
        }
        if (doubleStarName != null) {
            newFunction.append(",").append(doubleStarName);
            if (addDouble) {
                if (addComma) {
                    superCall.append(",");
                }
                superCall.append(doubleStarName);
            }
        }
    }
}

