/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveStatementQuickFix;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyUnusedLocalInspectionVisitor
extends PyInspectionVisitor {
    private final boolean myIgnoreTupleUnpacking;
    private final boolean myIgnoreLambdaParameters;
    private final boolean myIgnoreRangeIterationVariables;
    private final HashSet<PsiElement> myUnusedElements;
    private final HashSet<PsiElement> myUsedElements;

    public PyUnusedLocalInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, boolean ignoreTupleUnpacking, boolean ignoreLambdaParameters, boolean ignoreRangeIterationVariables) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor", "<init>"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor", "<init>"));
        }
        super(holder, session);
        this.myIgnoreTupleUnpacking = ignoreTupleUnpacking;
        this.myIgnoreLambdaParameters = ignoreLambdaParameters;
        this.myIgnoreRangeIterationVariables = ignoreRangeIterationVariables;
        this.myUnusedElements = new HashSet();
        this.myUsedElements = new HashSet();
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        this.processScope(node);
    }

    @Override
    public void visitPyLambdaExpression(PyLambdaExpression node) {
        this.processScope(node);
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.processScope(node);
    }

    private void processScope(ScopeOwner owner) {
        if (owner.getContainingFile() instanceof PyExpressionCodeFragment || PyUnusedLocalInspectionVisitor.callsLocals(owner)) {
            return;
        }
        if (!(owner instanceof PyClass)) {
            this.collectAllWrites(owner);
        }
        this.collectUsedReads(owner);
    }

    private void collectAllWrites(ScopeOwner owner) {
        Instruction[] instructions;
        for (Instruction instruction : instructions = ControlFlowCache.getControlFlow(owner).getInstructions()) {
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            PsiElement element = instruction.getElement();
            if (element instanceof PyFunction && owner instanceof PyFunction) {
                if (PyKnownDecoratorUtil.hasUnknownDecorator((PyFunction)element, this.myTypeEvalContext) || this.myUsedElements.contains(element)) continue;
                this.myUnusedElements.add(element);
                continue;
            }
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isWriteAccess()) continue;
            String name = readWriteInstruction.getName();
            Scope scope = ControlFlowCache.getScope(owner);
            if (name == null || "_".equals(name) || scope.isGlobal(name) || scope.isNonlocal(name) || element == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false) || PyImportStatementNavigator.getImportStatementByElement(element) != null || PyAugAssignmentStatementNavigator.getStatementByTarget(element) != null || this.myUsedElements.contains(element)) continue;
            this.myUnusedElements.add(element);
        }
    }

    private void collectUsedReads(final ScopeOwner owner) {
        Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            PyReferenceExpression ref;
            ScopeOwner declOwner;
            int startInstruction;
            PsiElement element;
            String name;
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            Instruction instruction = instructions[i];
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isReadAccess() || (name = readWriteInstruction.getName()) == null || (element = instruction.getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false)) continue;
            if (access.isWriteAccess()) {
                PyAugAssignmentStatement augAssignmentStatement = PyAugAssignmentStatementNavigator.getStatementByTarget(element);
                startInstruction = ControlFlowUtil.findInstructionNumberByElement(instructions, (PsiElement)augAssignmentStatement);
            } else {
                startInstruction = i;
            }
            if (element instanceof PyReferenceExpression && (declOwner = ScopeUtil.getDeclarationScopeOwner((PsiElement)(ref = (PyReferenceExpression)element), name)) != null && declOwner != owner) {
                Collection<PsiElement> writeElements = ScopeUtil.getReadWriteElements(name, declOwner, false, true);
                for (PsiElement e : writeElements) {
                    this.myUsedElements.add(e);
                    this.myUnusedElements.remove(e);
                }
            }
            ControlFlowUtil.iteratePrev(startInstruction, instructions, new Function<Instruction, ControlFlowUtil.Operation>(){

                public ControlFlowUtil.Operation fun(Instruction inst) {
                    ReadWriteInstruction rwInstruction;
                    PsiElement element = inst.getElement();
                    if (element instanceof PyFunction) {
                        if (name.equals(((PyFunction)element).getName())) {
                            PyUnusedLocalInspectionVisitor.this.myUsedElements.add(element);
                            PyUnusedLocalInspectionVisitor.this.myUnusedElements.remove(element);
                            return ControlFlowUtil.Operation.CONTINUE;
                        }
                    } else if (inst instanceof ReadWriteInstruction && (rwInstruction = (ReadWriteInstruction)inst).getAccess().isWriteAccess() && name.equals(rwInstruction.getName())) {
                        if (element != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false)) {
                            PyUnusedLocalInspectionVisitor.this.myUsedElements.add(element);
                            PyUnusedLocalInspectionVisitor.this.myUnusedElements.remove(element);
                        }
                        return ControlFlowUtil.Operation.CONTINUE;
                    }
                    return ControlFlowUtil.Operation.NEXT;
                }
            });
        }
    }

    private static boolean callsLocals(ScopeOwner owner) {
        try {
            owner.acceptChildren(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyCallExpression(PyCallExpression node) {
                    PyExpression callee = node.getCallee();
                    if (callee != null && "locals".equals(callee.getName())) {
                        throw new DontPerformException();
                    }
                    node.acceptChildren(this);
                }

                @Override
                public void visitPyFunction(PyFunction node) {
                }
            });
        }
        catch (DontPerformException e) {
            return true;
        }
        return false;
    }

    void registerProblems() {
        PyInspectionExtension[] filters = (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME);
        HashSet<PyFunction> functionsWithInheritors = new HashSet<PyFunction>();
        HashMap<PyFunction, Boolean> emptyFunctions = new HashMap<PyFunction, Boolean>();
        for (PsiElement element : this.myUnusedElements) {
            boolean ignoreUnused = false;
            for (PyInspectionExtension filter : filters) {
                if (!filter.ignoreUnused(element)) continue;
                ignoreUnused = true;
            }
            if (ignoreUnused) continue;
            if (element instanceof PyFunction) {
                PsiElement nameIdentifier = ((PyFunction)element).getNameIdentifier();
                this.registerWarning(nameIdentifier == null ? element : nameIdentifier, PyBundle.message("INSP.unused.locals.local.function.isnot.used", ((PyFunction)element).getName()), new PyRemoveStatementQuickFix());
                continue;
            }
            if (element instanceof PyClass) {
                PyClass cls = (PyClass)element;
                PsiElement name = cls.getNameIdentifier();
                this.registerWarning(name != null ? name : element, PyBundle.message("INSP.unused.locals.local.class.isnot.used", cls.getName()), new PyRemoveStatementQuickFix());
                continue;
            }
            String name = element.getText();
            if (element instanceof PyNamedParameter || element.getParent() instanceof PyNamedParameter) {
                PyNamedParameter namedParameter = element instanceof PyNamedParameter ? (PyNamedParameter)element : (PyNamedParameter)element.getParent();
                name = namedParameter.getName();
                if (namedParameter.isSelf() || this.myIgnoreLambdaParameters && PsiTreeUtil.getParentOfType((PsiElement)element, Callable.class) instanceof PyLambdaExpression) continue;
                boolean mayBeField = false;
                PyClass containingClass = null;
                PyParameterList paramList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class);
                if (paramList != null && paramList.getParent() instanceof PyFunction) {
                    PyFunction func = (PyFunction)paramList.getParent();
                    containingClass = func.getContainingClass();
                    if ("__init__".equals(func.getName()) && containingClass != null) {
                        if (!namedParameter.isKeywordContainer() && !namedParameter.isPositionalContainer()) {
                            mayBeField = true;
                        }
                    } else if (PyUnusedLocalInspectionVisitor.ignoreUnusedParameters(func, functionsWithInheritors)) continue;
                    if (func.asMethod() != null) {
                        Boolean isEmpty = (Boolean)emptyFunctions.get(func);
                        if (isEmpty == null) {
                            isEmpty = PyUnusedLocalInspectionVisitor.isEmptyFunction(func);
                            emptyFunctions.put(func, isEmpty);
                        }
                        if (isEmpty.booleanValue() && !mayBeField) continue;
                    }
                }
                boolean canRemove = !(PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PyParameter.class) instanceof PySingleStarParameter) || PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PyParameter.class) != null;
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (mayBeField) {
                    fixes.add(new AddFieldQuickFix(name, name, containingClass.getName(), false));
                }
                if (canRemove) {
                    fixes.add(new PyRemoveParameterQuickFix());
                }
                this.registerWarning(element, PyBundle.message("INSP.unused.locals.parameter.isnot.used", name), fixes.toArray(new LocalQuickFix[fixes.size()]));
                continue;
            }
            if (this.myIgnoreTupleUnpacking && this.isTupleUnpacking(element)) continue;
            PyForStatement forStatement = PyForStatementNavigator.getPyForStatementByIterable(element);
            if (forStatement != null) {
                if (this.myIgnoreRangeIterationVariables && this.isRangeIteration(forStatement)) continue;
                this.registerProblem(element, PyBundle.message("INSP.unused.locals.local.variable.isnot.used", name), ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, new ReplaceWithWildCard());
                continue;
            }
            this.registerWarning(element, PyBundle.message("INSP.unused.locals.local.variable.isnot.used", name), new PyRemoveStatementQuickFix());
        }
    }

    private boolean isRangeIteration(PyForStatement forStatement) {
        Callable callee;
        PyExpression source = forStatement.getForPart().getSource();
        if (!(source instanceof PyCallExpression)) {
            return false;
        }
        PyCallExpression expr = (PyCallExpression)source;
        return expr.isCalleeText("range", "xrange") && (callee = expr.resolveCalleeFunction(PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext))) != null && PyBuiltinCache.getInstance(forStatement).isBuiltin((PsiElement)callee);
    }

    private static boolean ignoreUnusedParameters(PyFunction func, Set<PyFunction> functionsWithInheritors) {
        if (functionsWithInheritors.contains(func)) {
            return true;
        }
        if (PySuperMethodsSearch.search(func).findFirst() != null || PyOverridingMethodsSearch.search(func, true).findFirst() != null) {
            functionsWithInheritors.add(func);
            return true;
        }
        return false;
    }

    private boolean isTupleUnpacking(PsiElement element) {
        if (!(element instanceof PyTargetExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PyStarExpression) {
            element = parent;
            parent = element.getParent();
        }
        if (parent instanceof PyTupleExpression) {
            PyTupleExpression tuple = (PyTupleExpression)parent;
            for (PyExpression expression : tuple.getElements()) {
                if (!(expression instanceof PyStarExpression ? !this.myUnusedElements.contains(((PyStarExpression)expression).getExpression()) : !this.myUnusedElements.contains(expression))) continue;
                return true;
            }
        }
        return false;
    }

    private void registerWarning(@NotNull PsiElement element, String msg, LocalQuickFix ... quickfixes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor", "registerWarning"));
        }
        this.registerProblem(element, msg, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, quickfixes);
    }

    private static boolean isEmptyFunction(@NotNull PyFunction f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor", "isEmptyFunction"));
        }
        PyStatementList statementList = f.getStatementList();
        PyStatement[] statements = statementList.getStatements();
        if (statements.length == 0) {
            return true;
        }
        return statements.length == 1 ? PyUnusedLocalInspectionVisitor.isStringLiteral(statements[0]) || PyUnusedLocalInspectionVisitor.isPassOrRaiseOrEmptyReturn(statements[0]) : statements.length == 2 && PyUnusedLocalInspectionVisitor.isStringLiteral(statements[0]) && PyUnusedLocalInspectionVisitor.isPassOrRaiseOrEmptyReturn(statements[1]);
    }

    private static boolean isPassOrRaiseOrEmptyReturn(PyStatement stmt) {
        if (stmt instanceof PyPassStatement || stmt instanceof PyRaiseStatement) {
            return true;
        }
        return stmt instanceof PyReturnStatement && ((PyReturnStatement)stmt).getExpression() == null;
    }

    private static boolean isStringLiteral(PyStatement stmt) {
        PyExpression expr;
        return stmt instanceof PyExpressionStatement && (expr = ((PyExpressionStatement)stmt).getExpression()) instanceof PyStringLiteralExpression;
    }

    private static class ReplaceWithWildCard
    implements LocalQuickFix {
        private ReplaceWithWildCard() {
        }

        @NotNull
        public String getName() {
            String string = PyBundle.message("INSP.unused.locals.replace.with.wildcard", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard", "applyFix"));
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor.getPsiElement())) {
                return;
            }
            this.replace(descriptor.getPsiElement());
        }

        private void replace(final PsiElement psiElement) {
            PyFile pyFile = (PyFile)PyElementGenerator.getInstance(psiElement.getProject()).createDummyFile(LanguageLevel.getDefault(), "for _ in tuples:\n  pass");
            final PyExpression target = ((PyForStatement)pyFile.getStatements().get(0)).getForPart().getTarget();
            CommandProcessor.getInstance().executeCommand(psiElement.getProject(), new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            if (target != null) {
                                psiElement.replace((PsiElement)target);
                            }
                        }
                    });
                }
            }, this.getName(), null);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard", "getFamilyName"));
            }
            return string;
        }
    }

    static class DontPerformException
    extends RuntimeException {
        DontPerformException() {
        }
    }
}

