/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyUnreachableCodeInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.unreachable.code", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyUnreachableCodeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyUnreachableCodeInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnreachableCodeInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyUnreachableCodeInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static boolean hasAnyInterruptedControlFlowPaths(@NotNull PsiElement element) {
        ControlFlow flow;
        Instruction[] instructions;
        int start;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyUnreachableCodeInspection", "hasAnyInterruptedControlFlowPaths"));
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner(element);
        if (owner != null && (start = ControlFlowUtil.findInstructionNumberByElement(instructions = (flow = ControlFlowCache.getControlFlow(owner)).getInstructions(), element)) >= 0) {
            final Ref resultRef = Ref.create((Object)false);
            ControlFlowUtil.iteratePrev(start, instructions, new Function<Instruction, ControlFlowUtil.Operation>(){

                public ControlFlowUtil.Operation fun(Instruction instruction) {
                    if (instruction.allPred().isEmpty() && !PyUnreachableCodeInspection.isFirstInstruction(instruction)) {
                        resultRef.set((Object)true);
                        return ControlFlowUtil.Operation.BREAK;
                    }
                    return ControlFlowUtil.Operation.NEXT;
                }
            });
            return (Boolean)resultRef.get();
        }
        return false;
    }

    private static boolean isFirstInstruction(Instruction instruction) {
        return instruction.num() == 0;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyUnreachableCodeInspection$Visitor", "<init>"));
            }
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnreachableCodeInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        public void visitElement(PsiElement element) {
            if (element instanceof ScopeOwner) {
                ControlFlow flow = ControlFlowCache.getControlFlow((ScopeOwner)element);
                Instruction[] instructions = flow.getInstructions();
                final ArrayList unreachable = new ArrayList();
                if (instructions.length > 0) {
                    ControlFlowUtil.iteratePrev(instructions.length - 1, instructions, new Function<Instruction, ControlFlowUtil.Operation>(){

                        public ControlFlowUtil.Operation fun(Instruction instruction) {
                            if (instruction.allPred().isEmpty() && !PyUnreachableCodeInspection.isFirstInstruction(instruction)) {
                                unreachable.add(instruction.getElement());
                            }
                            return ControlFlowUtil.Operation.NEXT;
                        }
                    });
                }
                for (PsiElement e : unreachable) {
                    this.registerProblem(e, PyBundle.message("INSP.unreachable.code", new Object[0]));
                }
            }
        }
    }
}

