/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveUnnecessaryBackslashQuickFix;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnnecessaryBackslashInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.unnecessary.backslash", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyUnnecessaryBackslashInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyParameterList(PyParameterList list) {
            this.findProblem((PsiElement)list);
        }

        @Override
        public void visitPyArgumentList(PyArgumentList list) {
            this.findProblem((PsiElement)list);
        }

        @Override
        public void visitPyTupleExpression(PyTupleExpression node) {
            if (node.getParent() instanceof PyParenthesizedExpression) {
                this.findProblem((PsiElement)node);
            }
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression expression) {
            Stack stack = new Stack();
            stack.push((Object)expression);
            while (!stack.isEmpty()) {
                PsiElement element = (PsiElement)stack.pop();
                if (element instanceof PyTupleExpression) continue;
                this.findProblem(element);
                if (element == null) continue;
                for (PsiElement psiElement : element.getChildren()) {
                    stack.push((Object)psiElement);
                }
            }
        }

        @Override
        public void visitPyDictLiteralExpression(PyDictLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyListLiteralExpression(PyListLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPySetLiteralExpression(PySetLiteralExpression expression) {
            this.findProblem((PsiElement)expression);
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression stringLiteralExpression) {
            PsiElement parent = stringLiteralExpression.getParent();
            if (parent instanceof PyListLiteralExpression || parent instanceof PyParenthesizedExpression || parent instanceof PySetLiteralExpression || parent instanceof PyKeyValueExpression || parent instanceof PyNamedParameter || parent instanceof PyArgumentList) {
                this.findProblem(stringLiteralExpression);
            }
        }

        private void findProblem(@Nullable PsiElement expression) {
            PsiWhiteSpace[] children = (PsiWhiteSpace[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, PsiWhiteSpace.class);
            if (children != null) {
                for (PsiWhiteSpace ws : children) {
                    if (!ws.getText().contains("\\")) continue;
                    this.registerProblem((PsiElement)ws, "Unnecessary backslash in expression.", new RemoveUnnecessaryBackslashQuickFix());
                }
            }
        }
    }
}

