/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeCheckerInspection
extends PyInspection {
    private static final Logger LOG = Logger.getInstance((String)PyTypeCheckerInspection.class.getName());
    private static Key<Long> TIME_KEY = Key.create((String)"PyTypeCheckerInspection.StartTime");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyTypeCheckerInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTypeCheckerInspection", "buildVisitor"));
        }
        if (LOG.isDebugEnabled()) {
            session.putUserData(TIME_KEY, (Object)System.nanoTime());
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyTypeCheckerInspection", "buildVisitor"));
        }
        return visitor;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        Long startTime;
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTypeCheckerInspection", "inspectionFinished"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemsHolder", "com/jetbrains/python/inspections/PyTypeCheckerInspection", "inspectionFinished"));
        }
        if (LOG.isDebugEnabled() && (startTime = (Long)session.getUserData(TIME_KEY)) != null) {
            LOG.debug(String.format("[%d] elapsed time: %d ms\n", Thread.currentThread().getId(), (System.nanoTime() - startTime) / 1000000L));
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Type checker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyTypeCheckerInspection", "getDisplayName"));
        }
        return "Type checker";
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPySubscriptionExpression(PySubscriptionExpression node) {
            this.checkCallSite(node);
        }

        @Override
        public void visitPyForStatement(PyForStatement node) {
            PyType type;
            PyExpression source = node.getForPart().getSource();
            if (source != null && (type = this.myTypeEvalContext.getType(source)) != null && !PyTypeChecker.isUnknown(type) && !PyABCUtil.isSubtype(type, "Iterable", this.myTypeEvalContext)) {
                this.registerProblem((PsiElement)source, String.format("Expected 'collections.Iterable', got '%s' instead", PythonDocumentationProvider.getTypeName(type, this.myTypeEvalContext)));
            }
        }

        private void checkCallSite(@Nullable PyCallSiteExpression callSite) {
            LinkedHashMap substitutions = new LinkedHashMap();
            PyTypeChecker.AnalyzeCallResults results = PyTypeChecker.analyzeCallSite(callSite, this.myTypeEvalContext);
            if (results != null) {
                boolean genericsCollected = false;
                for (Map.Entry<PyExpression, PyNamedParameter> entry : results.getArguments().entrySet()) {
                    PyType paramType;
                    PyNamedParameter p = entry.getValue();
                    if (p.isPositionalContainer() || p.isKeywordContainer() || (paramType = this.myTypeEvalContext.getType(p)) == null) continue;
                    PyType argType = this.myTypeEvalContext.getType(entry.getKey());
                    if (!genericsCollected) {
                        substitutions.putAll(PyTypeChecker.unifyReceiver(results.getReceiver(), this.myTypeEvalContext));
                        genericsCollected = true;
                    }
                    this.checkTypes(paramType, argType, (PsiElement)entry.getKey(), this.myTypeEvalContext, (Map<PyGenericType, PyType>)substitutions);
                }
            }
        }

        @Nullable
        private String checkTypes(@Nullable PyType superType, @Nullable PyType subType, @Nullable PsiElement node, @NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> substitutions) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor", "checkTypes"));
            }
            if (substitutions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/inspections/PyTypeCheckerInspection$Visitor", "checkTypes"));
            }
            if (subType != null && superType != null && !PyTypeChecker.match(superType, subType, context, substitutions)) {
                PyType subst;
                String superName = PythonDocumentationProvider.getTypeName(superType, context);
                String expected = String.format("'%s'", superName);
                boolean hasGenerics = PyTypeChecker.hasGenerics(superType, context);
                ProblemHighlightType highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (hasGenerics && (subst = PyTypeChecker.substitute(superType, substitutions, context)) != null) {
                    expected = String.format("'%s' (matched generic type '%s')", PythonDocumentationProvider.getTypeName(subst, context), superName);
                    highlightType = ProblemHighlightType.WEAK_WARNING;
                }
                String msg = String.format("Expected type %s, got '%s' instead", expected, PythonDocumentationProvider.getTypeName(subType, context));
                this.registerProblem(node, msg, highlightType);
                return msg;
            }
            return null;
        }
    }
}

