/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTupleAssignmentBalanceInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.incorrect.assignment", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTupleAssignmentBalanceInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression lhsExpression = node.getLeftHandSideExpression();
            PyExpression assignedValue = node.getAssignedValue();
            if (lhsExpression instanceof PyParenthesizedExpression) {
                lhsExpression = ((PyParenthesizedExpression)lhsExpression).getContainedExpression();
            }
            if (assignedValue == null) {
                return;
            }
            PyType type = this.myTypeEvalContext.getType(assignedValue);
            if (assignedValue instanceof PyReferenceExpression && !(type instanceof PyTupleType)) {
                return;
            }
            if (lhsExpression instanceof PyTupleExpression && type != null) {
                int targetsLength;
                int valuesLength = PyUtil.getElementsCount(assignedValue, this.myTypeEvalContext);
                if (valuesLength == -1) {
                    return;
                }
                PyExpression[] elements = ((PyTupleExpression)lhsExpression).getElements();
                boolean containsStarExpression = false;
                if (LanguageLevel.forElement(node).isPy3K()) {
                    for (PyExpression target : elements) {
                        if (!(target instanceof PyStarExpression)) continue;
                        if (containsStarExpression) {
                            this.registerProblem((PsiElement)target, "Only one starred expression allowed in assignment");
                            return;
                        }
                        containsStarExpression = true;
                        ++valuesLength;
                    }
                }
                if ((targetsLength = elements.length) > valuesLength) {
                    this.registerProblem((PsiElement)assignedValue, "Need more values to unpack");
                } else if (!containsStarExpression && targetsLength < valuesLength) {
                    this.registerProblem((PsiElement)assignedValue, "Too many values to unpack");
                }
            }
        }
    }
}

