/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingSemicolonQuickFix;
import com.jetbrains.python.psi.PyStatement;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTrailingSemicolonInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.trailing.semicolon", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyTrailingSemicolonInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyTrailingSemicolonInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTrailingSemicolonInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyTrailingSemicolonInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyTrailingSemicolonInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyStatement(PyStatement statement) {
            ASTNode statementNode = statement.getNode();
            if (statementNode != null) {
                ASTNode[] nodes;
                for (ASTNode node : nodes = statementNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.SEMICOLON}))) {
                    ASTNode nextNode = statementNode.getTreeNext();
                    while (nextNode instanceof PsiWhiteSpace && !nextNode.textContains('\n')) {
                        nextNode = nextNode.getTreeNext();
                    }
                    if (nextNode != null && !nextNode.textContains('\n')) continue;
                    this.registerProblem(node.getPsi(), "Trailing semicolon in the statement", new RemoveTrailingSemicolonQuickFix());
                }
            }
        }
    }
}

