/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySuperArgumentsInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.wrong.super.arguments", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PySuperArgumentsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PySuperArgumentsInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySuperArgumentsInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PySuperArgumentsInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyExpression[] arguments;
            PyExpression callee = node.getCallee();
            if (callee != null && "super".equals(callee.getName()) && (arguments = node.getArguments()).length == 2 && arguments[0] instanceof PyReferenceExpression && arguments[1] instanceof PyReferenceExpression) {
                PyClass firstClass = this.findClassOf(arguments[0]);
                PyClass secondClass = this.findClassOf(arguments[1]);
                if (firstClass != null && secondClass != null && !secondClass.isSubclass(firstClass)) {
                    this.registerProblem((PsiElement)node.getArgumentList(), PyBundle.message("INSP.$0.is.not.superclass.of.$1", secondClass.getName(), firstClass.getName()));
                }
            }
        }

        @Nullable
        private PyClass findClassOf(PyExpression argument) {
            PyType first_type;
            PsiElement firstElement = ((PyReferenceExpression)argument).followAssignmentsChain(this.getResolveContext()).getElement();
            PyClass firstClass = null;
            if (firstElement instanceof PyClass) {
                firstClass = (PyClass)firstElement;
            } else if (firstElement instanceof PyExpression && (first_type = this.myTypeEvalContext.getType((PyExpression)firstElement)) instanceof PyClassType) {
                firstClass = ((PyClassType)first_type).getPyClass();
            }
            return firstClass;
        }
    }
}

