/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringFormatParser {
    private static final Pattern NEW_STYLE_FORMAT_TOKENS = Pattern.compile("(\\{\\{)|(\\}\\})|(\\{[^\\{\\}]*\\})|([^\\{\\}]+)");
    @NotNull
    private final String myLiteral;
    @NotNull
    private final List<FormatStringChunk> myResult;
    private int myPos;
    private static final String CONVERSION_FLAGS = "#0- +";
    private static final String DIGITS = "0123456789";
    private static final String LENGTH_MODIFIERS = "hlL";
    private static final String VALID_CONVERSION_TYPES = "diouxXeEfFgGcrs";

    private PyStringFormatParser(@NotNull String literal) {
        if (literal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literal", "com/jetbrains/python/inspections/PyStringFormatParser", "<init>"));
        }
        this.myResult = new ArrayList<FormatStringChunk>();
        this.myLiteral = literal;
    }

    @NotNull
    public static List<FormatStringChunk> parsePercentFormat(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/inspections/PyStringFormatParser", "parsePercentFormat"));
        }
        List<FormatStringChunk> list = new PyStringFormatParser(s).parse();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "parsePercentFormat"));
        }
        return list;
    }

    @NotNull
    public static List<FormatStringChunk> parseNewStyleFormat(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/inspections/PyStringFormatParser", "parseNewStyleFormat"));
        }
        ArrayList<FormatStringChunk> results = new ArrayList<FormatStringChunk>();
        Matcher matcher = NEW_STYLE_FORMAT_TOKENS.matcher(s);
        while (matcher.find()) {
            String group = matcher.group();
            int start = matcher.start();
            int end = matcher.end();
            if ("{{".equals(group) || "}}".equals(group)) {
                results.add(new ConstantChunk(start, end));
                continue;
            }
            if (group.startsWith("{") && group.endsWith("}")) {
                SubstitutionChunk chunk = new SubstitutionChunk(start);
                chunk.setEndIndex(end);
                int nameStart = start + 1;
                int nameEnd = StringUtil.indexOfAny((String)s, (String)"!:.[}", (int)nameStart, (int)end);
                if (nameEnd > 0 && nameStart < nameEnd) {
                    String name = s.substring(nameStart, nameEnd);
                    try {
                        int number = Integer.parseInt(name);
                        chunk.setPosition(number);
                    }
                    catch (NumberFormatException e) {
                        chunk.setMappingKey(name);
                    }
                }
                results.add(chunk);
                continue;
            }
            results.add(new ConstantChunk(start, end));
        }
        ArrayList<FormatStringChunk> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "parseNewStyleFormat"));
        }
        return arrayList;
    }

    @NotNull
    private List<FormatStringChunk> parse() {
        this.myPos = 0;
        while (this.myPos < this.myLiteral.length()) {
            int next = this.myLiteral.indexOf(37, this.myPos);
            while (next >= 0 && next < this.myLiteral.length() - 1 && this.myLiteral.charAt(next + 1) == '%') {
                next = this.myLiteral.indexOf(37, next + 2);
            }
            if (next < 0) break;
            if (next > this.myPos) {
                this.myResult.add(new ConstantChunk(this.myPos, next));
            }
            this.myPos = next;
            this.parseSubstitution();
        }
        if (this.myPos < this.myLiteral.length()) {
            this.myResult.add(new ConstantChunk(this.myPos, this.myLiteral.length()));
        }
        List<FormatStringChunk> list = this.myResult;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "parse"));
        }
        return list;
    }

    private void parseSubstitution() {
        assert (this.myLiteral.charAt(this.myPos) == '%');
        SubstitutionChunk chunk = new SubstitutionChunk(this.myPos);
        this.myResult.add(chunk);
        ++this.myPos;
        if (this.isAt('(')) {
            int mappingEnd = this.myLiteral.indexOf(41, this.myPos + 1);
            if (mappingEnd < 0) {
                chunk.setEndIndex(this.myLiteral.length());
                chunk.setMappingKey(this.myLiteral.substring(this.myPos + 1));
                chunk.setUnclosedMapping(true);
                this.myPos = this.myLiteral.length();
                return;
            }
            chunk.setMappingKey(this.myLiteral.substring(this.myPos + 1, mappingEnd));
            this.myPos = mappingEnd + 1;
        }
        chunk.setConversionFlags(this.parseWhileCharacterInSet(CONVERSION_FLAGS));
        chunk.setWidth(this.parseWidth());
        if (this.isAt('.')) {
            ++this.myPos;
            chunk.setPrecision(this.parseWidth());
        }
        if (this.isAtSet(LENGTH_MODIFIERS)) {
            chunk.setLengthModifier(this.myLiteral.charAt(this.myPos));
            ++this.myPos;
        }
        if (this.isAtSet(VALID_CONVERSION_TYPES)) {
            chunk.setConversionType(this.myLiteral.charAt(this.myPos));
            ++this.myPos;
        }
        chunk.setEndIndex(this.myPos);
    }

    private boolean isAtSet(@NotNull String characterSet) {
        if (characterSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "characterSet", "com/jetbrains/python/inspections/PyStringFormatParser", "isAtSet"));
        }
        return this.myPos < this.myLiteral.length() && characterSet.indexOf(this.myLiteral.charAt(this.myPos)) >= 0;
    }

    private boolean isAt(char c) {
        return this.myPos < this.myLiteral.length() && this.myLiteral.charAt(this.myPos) == c;
    }

    @NotNull
    private String parseWidth() {
        if (this.isAt('*')) {
            ++this.myPos;
            if ("*" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "parseWidth"));
            }
            return "*";
        }
        String string = this.parseWhileCharacterInSet(DIGITS);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "parseWidth"));
        }
        return string;
    }

    @NotNull
    private String parseWhileCharacterInSet(@NotNull String characterSet) {
        if (characterSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "characterSet", "com/jetbrains/python/inspections/PyStringFormatParser", "parseWhileCharacterInSet"));
        }
        int flagStart = this.myPos;
        while (this.isAtSet(characterSet)) {
            ++this.myPos;
        }
        String string = this.myLiteral.substring(flagStart, this.myPos);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "parseWhileCharacterInSet"));
        }
        return string;
    }

    @NotNull
    public static List<SubstitutionChunk> filterSubstitutions(@NotNull List<FormatStringChunk> chunks) {
        if (chunks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunks", "com/jetbrains/python/inspections/PyStringFormatParser", "filterSubstitutions"));
        }
        ArrayList<SubstitutionChunk> results = new ArrayList<SubstitutionChunk>();
        for (FormatStringChunk chunk : chunks) {
            if (!(chunk instanceof SubstitutionChunk)) continue;
            results.add((SubstitutionChunk)chunk);
        }
        ArrayList<SubstitutionChunk> arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "filterSubstitutions"));
        }
        return arrayList;
    }

    @NotNull
    public static List<SubstitutionChunk> getPositionalSubstitutions(@NotNull List<SubstitutionChunk> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/inspections/PyStringFormatParser", "getPositionalSubstitutions"));
        }
        ArrayList<SubstitutionChunk> result = new ArrayList<SubstitutionChunk>();
        for (SubstitutionChunk s : substitutions) {
            if (s.getMappingKey() != null) continue;
            result.add(s);
        }
        ArrayList<SubstitutionChunk> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "getPositionalSubstitutions"));
        }
        return arrayList;
    }

    @NotNull
    public static Map<String, SubstitutionChunk> getKeywordSubstitutions(@NotNull List<SubstitutionChunk> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/inspections/PyStringFormatParser", "getKeywordSubstitutions"));
        }
        HashMap result = new HashMap();
        for (SubstitutionChunk s : substitutions) {
            String key = s.getMappingKey();
            if (key == null) continue;
            result.put(key, s);
        }
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "getKeywordSubstitutions"));
        }
        return hashMap;
    }

    @NotNull
    public static List<TextRange> substitutionsToRanges(@NotNull List<SubstitutionChunk> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutions", "com/jetbrains/python/inspections/PyStringFormatParser", "substitutionsToRanges"));
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (SubstitutionChunk substitution : substitutions) {
            ranges.add(TextRange.create((int)substitution.getStartIndex(), (int)substitution.getEndIndex()));
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "substitutionsToRanges"));
        }
        return arrayList;
    }

    @Nullable
    public static PyExpression getFormatValueExpression(@NotNull PyStringLiteralExpression element) {
        PyBinaryExpression binaryExpr;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyStringFormatParser", "getFormatValueExpression"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PyBinaryExpression && (binaryExpr = (PyBinaryExpression)parent).isOperator("%")) {
            PyExpression expr = binaryExpr.getRightExpression();
            while (expr instanceof PyParenthesizedExpression) {
                expr = ((PyParenthesizedExpression)expr).getContainedExpression();
            }
            return expr;
        }
        return null;
    }

    @Nullable
    public static PyArgumentList getNewStyleFormatValueExpression(@NotNull PyStringLiteralExpression element) {
        PsiElement parent2;
        PyQualifiedExpression qualifiedExpr;
        String name;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyStringFormatParser", "getNewStyleFormatValueExpression"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PyQualifiedExpression && "format".equals(name = (qualifiedExpr = (PyQualifiedExpression)parent).getReferencedName()) && (parent2 = qualifiedExpr.getParent()) instanceof PyCallExpression) {
            PyCallExpression callExpr = (PyCallExpression)parent2;
            return callExpr.getArgumentList();
        }
        return null;
    }

    @NotNull
    public static List<TextRange> getEscapeRanges(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/inspections/PyStringFormatParser", "getEscapeRanges"));
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        Matcher matcher = PyStringLiteralExpressionImpl.PATTERN_ESCAPE.matcher(s);
        while (matcher.find()) {
            ranges.add(TextRange.create((int)matcher.start(), (int)matcher.end()));
        }
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser", "getEscapeRanges"));
        }
        return arrayList;
    }

    public static class SubstitutionChunk
    extends FormatStringChunk {
        @Nullable
        private String myMappingKey;
        @Nullable
        private String myConversionFlags;
        @Nullable
        private String myWidth;
        @Nullable
        private String myPrecision;
        @Nullable
        private Integer myPosition;
        private char myLengthModifier;
        private char myConversionType;
        private boolean myUnclosedMapping;

        public SubstitutionChunk(int startIndex) {
            super(startIndex, startIndex);
        }

        private void setEndIndex(int endIndex) {
            this.myEndIndex = endIndex;
        }

        public char getConversionType() {
            return this.myConversionType;
        }

        private void setConversionType(char conversionType) {
            this.myConversionType = conversionType;
        }

        @Nullable
        public String getMappingKey() {
            return this.myMappingKey;
        }

        private void setMappingKey(@Nullable String mappingKey) {
            this.myMappingKey = mappingKey;
        }

        @Nullable
        public String getConversionFlags() {
            return this.myConversionFlags;
        }

        private void setConversionFlags(@Nullable String conversionFlags) {
            this.myConversionFlags = conversionFlags;
        }

        @Nullable
        public String getWidth() {
            return this.myWidth;
        }

        private void setWidth(@Nullable String width) {
            this.myWidth = width;
        }

        @Nullable
        public String getPrecision() {
            return this.myPrecision;
        }

        private void setPrecision(@Nullable String precision) {
            this.myPrecision = precision;
        }

        public char getLengthModifier() {
            return this.myLengthModifier;
        }

        private void setLengthModifier(char lengthModifier) {
            this.myLengthModifier = lengthModifier;
        }

        public boolean isUnclosedMapping() {
            return this.myUnclosedMapping;
        }

        private void setUnclosedMapping(boolean unclosedMapping) {
            this.myUnclosedMapping = unclosedMapping;
        }

        @Nullable
        public Integer getPosition() {
            return this.myPosition;
        }

        private void setPosition(@Nullable Integer position) {
            this.myPosition = position;
        }
    }

    public static class ConstantChunk
    extends FormatStringChunk {
        public ConstantChunk(int startIndex, int endIndex) {
            super(startIndex, endIndex);
        }
    }

    public static abstract class FormatStringChunk {
        private final int myStartIndex;
        protected int myEndIndex;

        public FormatStringChunk(int startIndex, int endIndex) {
            this.myStartIndex = startIndex;
            this.myEndIndex = endIndex;
        }

        public int getStartIndex() {
            return this.myStartIndex;
        }

        public int getEndIndex() {
            return this.myEndIndex;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = TextRange.create((int)this.myStartIndex, (int)this.myEndIndex);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatParser$FormatStringChunk", "getTextRange"));
            }
            return textRange;
        }
    }
}

