/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.inspections.quickfix.PyAddSpecifierToFormatQuickFix;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PySubscriptableType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringFormatInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.str.format", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyStringFormatInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyStringFormatInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStringFormatInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            if (node.getLeftExpression() instanceof PyStringLiteralExpression && node.isOperator("%")) {
                Inspection inspection = new Inspection(this, this.myTypeEvalContext);
                PyStringLiteralExpression literalExpression = (PyStringLiteralExpression)node.getLeftExpression();
                inspection.inspectFormat(literalExpression);
                if (inspection.isProblem()) {
                    return;
                }
                inspection.inspectValues(node.getRightExpression());
            }
        }

        private static class Inspection {
            private static final ImmutableMap<Character, String> FORMAT_CONVERSIONS = ImmutableMap.builder().put((Object)Character.valueOf('d'), (Object)"int or long or float").put((Object)Character.valueOf('i'), (Object)"int or long or float").put((Object)Character.valueOf('o'), (Object)"int or long or float").put((Object)Character.valueOf('u'), (Object)"int or long or float").put((Object)Character.valueOf('x'), (Object)"int or long or float").put((Object)Character.valueOf('X'), (Object)"int or long or float").put((Object)Character.valueOf('e'), (Object)"float").put((Object)Character.valueOf('E'), (Object)"float").put((Object)Character.valueOf('f'), (Object)"float").put((Object)Character.valueOf('F'), (Object)"float").put((Object)Character.valueOf('g'), (Object)"float").put((Object)Character.valueOf('G'), (Object)"float").put((Object)Character.valueOf('c'), (Object)"str").put((Object)Character.valueOf('r'), (Object)"str").put((Object)Character.valueOf('s'), (Object)"str").build();
            private final Map<String, Boolean> myUsedMappingKeys = new HashMap();
            private int myExpectedArguments = 0;
            private boolean myProblemRegister = false;
            private final Visitor myVisitor;
            private final TypeEvalContext myTypeEvalContext;
            private final Map<String, String> myFormatSpec = new HashMap();

            public Inspection(Visitor visitor, TypeEvalContext typeEvalContext) {
                this.myVisitor = visitor;
                this.myTypeEvalContext = typeEvalContext;
            }

            private int inspectArguments(@Nullable PyExpression rightExpression, PsiElement problemTarget) {
                Class[] SIMPLE_RHS_EXPRESSIONS = new Class[]{PyLiteralExpression.class, PySubscriptionExpression.class, PyBinaryExpression.class, PyConditionalExpression.class};
                PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(problemTarget);
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                String s = this.myFormatSpec.get("1");
                if (PyUtil.instanceOf(rightExpression, SIMPLE_RHS_EXPRESSIONS)) {
                    if (s != null) {
                        PyType rightType = this.myTypeEvalContext.getType(rightExpression);
                        if (rightType instanceof PySubscriptableType) {
                            PySubscriptableType tupleType = (PySubscriptableType)rightType;
                            for (int i = 0; i <= tupleType.getElementCount(); ++i) {
                                PyType elementType = tupleType.getElementType(i);
                                if (elementType == null) continue;
                                String typeName = this.myFormatSpec.get(String.valueOf(i + 1));
                                PyType type = typeName != null ? PyTypeParser.getTypeByName(problemTarget, typeName) : null;
                                this.checkTypeCompatible(problemTarget, elementType, type);
                            }
                            return tupleType.getElementCount();
                        }
                        this.checkExpressionType(rightExpression, s, problemTarget);
                    }
                    return 1;
                }
                if (rightExpression instanceof PyReferenceExpression) {
                    if ("__dict__".equals(rightExpression.getName())) {
                        return -1;
                    }
                    PsiElement pyElement = ((PyReferenceExpression)rightExpression).followAssignmentsChain(resolveContext).getElement();
                    if (pyElement == rightExpression || !(pyElement instanceof PyExpression)) {
                        return -1;
                    }
                    if (pyElement instanceof PyDictLiteralExpression) {
                        return this.inspectDict(rightExpression, problemTarget, true);
                    }
                    return this.inspectArguments((PyExpression)pyElement, problemTarget);
                }
                if (rightExpression instanceof PyCallExpression) {
                    Callable callable = ((PyCallExpression)rightExpression).resolveCalleeFunction(resolveContext);
                    if (callable instanceof PyFunction && this.myTypeEvalContext.maySwitchToAST((PsiElement)callable)) {
                        PyStatementList statementList = ((PyFunction)callable).getStatementList();
                        PyReturnStatement[] returnStatements = (PyReturnStatement[])PyUtil.getAllChildrenOfType((PsiElement)statementList, PyReturnStatement.class);
                        int expressionsSize = -1;
                        for (PyReturnStatement returnStatement : returnStatements) {
                            if (returnStatement.getExpression() instanceof PyCallExpression) {
                                return -1;
                            }
                            List<PyExpression> expressionList = PyUtil.flattenedParensAndTuples(returnStatement.getExpression());
                            if (expressionsSize < 0) {
                                expressionsSize = expressionList.size();
                            }
                            if (expressionsSize == expressionList.size()) continue;
                            return -1;
                        }
                        return expressionsSize;
                    }
                    return -1;
                }
                if (rightExpression instanceof PyParenthesizedExpression) {
                    PyExpression rhs = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
                    return this.inspectArguments(rhs, (PsiElement)rhs);
                }
                if (rightExpression instanceof PyTupleExpression) {
                    PyExpression[] expressions = ((PyTupleExpression)rightExpression).getElements();
                    int i = 1;
                    for (PyExpression expression : expressions) {
                        String formatSpec = this.myFormatSpec.get(Integer.toString(i));
                        if (formatSpec != null) {
                            this.checkExpressionType(expression, formatSpec, (PsiElement)expression);
                        }
                        ++i;
                    }
                    return expressions.length;
                }
                if (rightExpression instanceof PyDictLiteralExpression) {
                    return this.inspectDict(rightExpression, problemTarget, false);
                }
                if (PyUtil.instanceOf(rightExpression, PySequenceExpression.class, PyComprehensionElement.class)) {
                    if (s != null) {
                        this.checkTypeCompatible(problemTarget, builtinCache.getStrType(), PyTypeParser.getTypeByName(problemTarget, s));
                        return 1;
                    }
                } else if (rightExpression instanceof PySliceExpression && s != null) {
                    PyType type = this.myTypeEvalContext.getType(((PySliceExpression)rightExpression).getOperand());
                    PyType stringType = PyBuiltinCache.getInstance((PsiElement)rightExpression).getStringType(LanguageLevel.forElement((PsiElement)rightExpression));
                    PyClassType listType = PyBuiltinCache.getInstance((PsiElement)rightExpression).getListType();
                    if (type == null || PyTypeChecker.match(listType, type, this.myTypeEvalContext) || PyTypeChecker.match(stringType, type, this.myTypeEvalContext)) {
                        this.checkTypeCompatible(problemTarget, builtinCache.getStrType(), PyTypeParser.getTypeByName(problemTarget, s));
                        return 1;
                    }
                    PySliceItem sliceItem = ((PySliceExpression)rightExpression).getSliceItem();
                    if (sliceItem != null) {
                        PyExpression lower = sliceItem.getLowerBound();
                        PyExpression upper = sliceItem.getUpperBound();
                        PyExpression stride = sliceItem.getStride();
                        if (upper instanceof PyNumericLiteralExpression) {
                            BigInteger lowerVal = lower instanceof PyNumericLiteralExpression ? ((PyNumericLiteralExpression)lower).getBigIntegerValue() : BigInteger.ZERO;
                            int count = ((PyNumericLiteralExpression)upper).getBigIntegerValue().subtract(lowerVal).intValue();
                            int strideVal = stride instanceof PyNumericLiteralExpression ? ((PyNumericLiteralExpression)stride).getBigIntegerValue().intValue() : 1;
                            int res = count / strideVal;
                            int residue = count % strideVal == 0 ? 0 : 1;
                            return res + residue;
                        }
                    }
                    return -1;
                }
                return -1;
            }

            private static Map<PyExpression, PyExpression> addSubscriptions(PsiFile file, String operand) {
                PySubscriptionExpression[] subscriptionExpressions;
                HashMap additionalExpressions = new HashMap();
                for (PySubscriptionExpression expr : subscriptionExpressions = (PySubscriptionExpression[])PyUtil.getAllChildrenOfType((PsiElement)file, PySubscriptionExpression.class)) {
                    PyExpression key;
                    PsiElement parent;
                    if (!expr.getOperand().getText().equals(operand) || !((parent = expr.getParent()) instanceof PyAssignmentStatement) || !expr.equals(((PyAssignmentStatement)parent).getLeftHandSideExpression()) || (key = expr.getIndexExpression()) == null) continue;
                    additionalExpressions.put(key, ((PyAssignmentStatement)parent).getAssignedValue());
                }
                return additionalExpressions;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private int inspectDict(PyExpression rightExpression, PsiElement problemTarget, boolean addSubscriptions) {
                PyExpression pyElement;
                Object additionalExpressions;
                if (addSubscriptions) {
                    additionalExpressions = Inspection.addSubscriptions(rightExpression.getContainingFile(), rightExpression.getText());
                    pyElement = ((PyReferenceExpression)rightExpression).followAssignmentsChain(PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext)).getElement();
                } else {
                    additionalExpressions = new HashMap();
                    pyElement = rightExpression;
                }
                if (pyElement == null) {
                    return 0;
                }
                PyKeyValueExpression[] expressions = ((PyDictLiteralExpression)pyElement).getElements();
                if (this.myUsedMappingKeys.isEmpty()) {
                    if (this.myExpectedArguments <= 0) return 0;
                    if (this.myExpectedArguments != expressions.length + additionalExpressions.size()) return 1;
                    this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.format.requires.no.mapping", new Object[0]));
                }
                for (PyKeyValueExpression expression : expressions) {
                    String name;
                    PyExpression key = expression.getKey();
                    if (!(key instanceof PyStringLiteralExpression) || this.myUsedMappingKeys.get(name = ((PyStringLiteralExpression)key).getStringValue()) == null) continue;
                    this.myUsedMappingKeys.put(name, true);
                    PyExpression value = expression.getValue();
                    if (value == null) continue;
                    this.checkExpressionType(value, this.myFormatSpec.get(name), problemTarget);
                }
                for (Map.Entry expression : additionalExpressions.entrySet()) {
                    String name;
                    PyExpression key = (PyExpression)expression.getKey();
                    if (!(key instanceof PyStringLiteralExpression) || this.myUsedMappingKeys.get(name = ((PyStringLiteralExpression)key).getStringValue()) == null) continue;
                    this.myUsedMappingKeys.put(name, true);
                    PyExpression value = (PyExpression)expression.getValue();
                    if (value == null) continue;
                    this.checkExpressionType(value, this.myFormatSpec.get(name), problemTarget);
                }
                for (String key : this.myUsedMappingKeys.keySet()) {
                    if (this.myUsedMappingKeys.get(key).booleanValue()) continue;
                    this.registerProblem(problemTarget, PyBundle.message("INSP.key.$0.has.no.arg", key));
                    return expressions.length + additionalExpressions.size();
                }
                return expressions.length + additionalExpressions.size();
            }

            private void registerProblem(@NotNull PsiElement problemTarget, @NotNull String message, @NotNull LocalQuickFix quickFix) {
                if (problemTarget == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemTarget", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "registerProblem"));
                }
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "registerProblem"));
                }
                if (quickFix == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFix", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "registerProblem"));
                }
                this.myProblemRegister = true;
                this.myVisitor.registerProblem(problemTarget, message, quickFix);
            }

            private void registerProblem(@NotNull PsiElement problemTarget, @NotNull String message) {
                if (problemTarget == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemTarget", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "registerProblem"));
                }
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "registerProblem"));
                }
                this.myProblemRegister = true;
                this.myVisitor.registerProblem(problemTarget, message);
            }

            private void checkExpressionType(@NotNull PyExpression expression, @NotNull String expectedTypeName, PsiElement problemTarget) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "checkExpressionType"));
                }
                if (expectedTypeName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedTypeName", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "checkExpressionType"));
                }
                PyType actual = this.myTypeEvalContext.getType(expression);
                PyType expected = PyTypeParser.getTypeByName(problemTarget, expectedTypeName);
                if (actual != null) {
                    this.checkTypeCompatible(problemTarget, actual, expected);
                }
            }

            private void checkTypeCompatible(@NotNull PsiElement problemTarget, @Nullable PyType actual, @Nullable PyType expected) {
                if (problemTarget == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemTarget", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "checkTypeCompatible"));
                }
                if (expected != null && "str".equals(expected.getName())) {
                    return;
                }
                if (actual != null && !PyTypeChecker.match(expected, actual, this.myTypeEvalContext)) {
                    this.registerProblem(problemTarget, PyBundle.message("INSP.unexpected.type.$0", actual.getName()));
                }
            }

            private void inspectFormat(@NotNull PyStringLiteralExpression formatExpression) {
                if (formatExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatExpression", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "inspectFormat"));
                }
                String value = formatExpression.getStringValue();
                List<PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(value));
                this.myExpectedArguments = chunks.size();
                this.myUsedMappingKeys.clear();
                boolean mapping = chunks.size() > 0 && chunks.get(0).getMappingKey() != null;
                for (int i = 0; i < chunks.size(); ++i) {
                    PyStringFormatParser.SubstitutionChunk chunk = chunks.get(i);
                    String mappingKey = Integer.toString(i + 1);
                    if (mapping) {
                        if (chunk.getMappingKey() == null || chunk.isUnclosedMapping()) {
                            this.registerProblem(formatExpression, PyBundle.message("INSP.too.few.keys", new Object[0]));
                            break;
                        }
                        mappingKey = chunk.getMappingKey();
                        this.myUsedMappingKeys.put(mappingKey, false);
                    }
                    this.inspectWidth(formatExpression, chunk.getWidth());
                    this.inspectWidth(formatExpression, chunk.getPrecision());
                    if (!FORMAT_CONVERSIONS.containsKey((Object)Character.valueOf(chunk.getConversionType()))) {
                        this.registerProblem(formatExpression, PyBundle.message("INSP.no.format.specifier.char", new Object[0]), new PyAddSpecifierToFormatQuickFix());
                        return;
                    }
                    this.myFormatSpec.put(mappingKey, (String)FORMAT_CONVERSIONS.get((Object)Character.valueOf(chunk.getConversionType())));
                }
            }

            private void inspectWidth(@NotNull PyStringLiteralExpression formatExpression, String width) {
                if (formatExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatExpression", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "inspectWidth"));
                }
                if ("*".equals(width)) {
                    ++this.myExpectedArguments;
                    if (this.myUsedMappingKeys.size() > 0) {
                        this.registerProblem(formatExpression, "Can't use '*' in formats when using a mapping");
                    }
                }
            }

            public boolean isProblem() {
                return this.myProblemRegister;
            }

            private void inspectValues(@Nullable PyExpression rightExpression) {
                if (rightExpression == null) {
                    return;
                }
                if (rightExpression instanceof PyParenthesizedExpression) {
                    this.inspectValues(((PyParenthesizedExpression)rightExpression).getContainedExpression());
                } else {
                    PyClassType type = PyUtil.as(this.myTypeEvalContext.getType(rightExpression), PyClassType.class);
                    if (type != null && this.myUsedMappingKeys.size() > 0 && !PyABCUtil.isSubclass(type.getPyClass(), "Mapping")) {
                        this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.format.requires.mapping", new Object[0]));
                        return;
                    }
                    this.inspectArgumentsNumber(rightExpression);
                }
            }

            private void inspectArgumentsNumber(@NotNull PyExpression rightExpression) {
                if (rightExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightExpression", "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection", "inspectArgumentsNumber"));
                }
                int arguments = this.inspectArguments(rightExpression, (PsiElement)rightExpression);
                if (this.myUsedMappingKeys.isEmpty() && arguments >= 0) {
                    if (this.myExpectedArguments < arguments) {
                        this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.too.many.args.for.fmt.string", new Object[0]));
                    } else if (this.myExpectedArguments > arguments) {
                        this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]));
                    }
                }
            }
        }
    }
}

