/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.StatementEffectFunctionCallQuickFix;
import com.jetbrains.python.inspections.quickfix.StatementEffectIntroduceVariableQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTryPart;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.types.PyType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStatementEffectInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.statement.effect", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStatementEffectInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyStatementEffectInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyStatementEffectInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyStatementEffectInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Override
    protected boolean isSuppressForCodeFragment() {
        return true;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyExpressionStatement(PyExpressionStatement node) {
            PyStatementList statementList;
            PyExpression expression = node.getExpression();
            if (PsiTreeUtil.hasErrorElements((PsiElement)expression)) {
                return;
            }
            if (this.hasEffect(expression)) {
                return;
            }
            if (expression instanceof PyStringLiteralExpression) {
                return;
            }
            PyTryPart tryPart = (PyTryPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyTryPart.class);
            if (tryPart != null && (statementList = tryPart.getStatementList()).getStatements().length == 1 && statementList.getStatements()[0] == node) {
                return;
            }
            if (expression instanceof PyReferenceExpression && !((PyReferenceExpression)expression).isQualified()) {
                this.registerProblem((PsiElement)expression, PyBundle.message("INSP.NAME.statement.message", new Object[0]));
            } else {
                this.registerProblem((PsiElement)expression, PyBundle.message("INSP.NAME.statement.message", new Object[0]), new StatementEffectIntroduceVariableQuickFix());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean hasEffect(@Nullable PyExpression expression) {
            PyExpression[] elements;
            if (expression == null) {
                return false;
            }
            if (expression instanceof PyCallExpression) return true;
            if (expression instanceof PyYieldExpression) {
                return true;
            }
            if (expression instanceof PyListCompExpression) {
                if (!this.hasEffect(((PyListCompExpression)expression).getResultExpression())) return false;
                return true;
            }
            if (expression instanceof PyBinaryExpression) {
                PyBinaryExpression binary = (PyBinaryExpression)expression;
                PyExpression leftExpression = binary.getLeftExpression();
                PyExpression rightExpression = binary.getRightExpression();
                if (this.hasEffect(leftExpression)) return true;
                if (this.hasEffect(rightExpression)) {
                    return true;
                }
                PyElementType operator = binary.getOperator();
                if (operator == null) {
                    return false;
                }
                String string = operator.getSpecialMethodName();
                String method = string;
                if (method == null) return false;
                PyType type = this.myTypeEvalContext.getType(leftExpression);
                if (type != null && !type.isBuiltin() && type.resolveMember(method, null, AccessDirection.READ, this.getResolveContext()) != null) {
                    return true;
                }
                if (rightExpression == null) return false;
                type = this.myTypeEvalContext.getType(rightExpression);
                if (type == null) return false;
                String rmethod = "__r" + method.substring(2);
                if (type.isBuiltin()) return false;
                if (type.resolveMember(rmethod, null, AccessDirection.READ, this.getResolveContext()) == null) return false;
                return true;
            }
            if (expression instanceof PyConditionalExpression) {
                PyConditionalExpression conditionalExpression = (PyConditionalExpression)expression;
                if (this.hasEffect(conditionalExpression.getTruePart())) return true;
                if (!this.hasEffect(conditionalExpression.getFalsePart())) return false;
                return true;
            }
            if (expression instanceof PyParenthesizedExpression) {
                PyParenthesizedExpression parenthesizedExpression = (PyParenthesizedExpression)expression;
                return this.hasEffect(parenthesizedExpression.getContainedExpression());
            }
            if (expression instanceof PyReferenceExpression) {
                ResolveResult[] results;
                PyReferenceExpression referenceExpression = (PyReferenceExpression)expression;
                ResolveResult[] arr$ = results = referenceExpression.getReference(this.getResolveContext()).multiResolve(true);
                int len$ = arr$.length;
                int i$ = 0;
                while (i$ < len$) {
                    ResolveResult res = arr$[i$];
                    if (res.getElement() instanceof PyFunction) {
                        this.registerProblem((PsiElement)expression, "Statement seems to have no effect and can be replaced with function call to have effect", new StatementEffectFunctionCallQuickFix());
                        return true;
                    }
                    ++i$;
                }
                return false;
            }
            if (!(expression instanceof PyTupleExpression)) return false;
            PyExpression[] arr$ = elements = ((PyTupleExpression)expression).getElements();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                PyExpression element = arr$[i$];
                if (this.hasEffect(element)) {
                    return true;
                }
                ++i$;
            }
            return false;
        }
    }
}

