/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.SimplifyBooleanCheckQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyConditionalStatementPart;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySimplifyBooleanCheckInspection
extends PyInspection {
    private static List<String> COMPARISON_LITERALS = ImmutableList.of((Object)"True", (Object)"False", (Object)"[]");
    public boolean ignoreComparisonToZero = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.check.can.be.simplified", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session, this.ignoreComparisonToZero);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection", "buildVisitor"));
        }
        return visitor;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Ignore comparison to zero", "ignoreComparisonToZero");
        return panel;
    }

    private static class PyBinaryExpressionVisitor
    extends PyInspectionVisitor {
        private final boolean myIgnoreComparisonToZero;

        public PyBinaryExpressionVisitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, boolean ignoreComparisonToZero) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$PyBinaryExpressionVisitor", "<init>"));
            }
            super(holder, session);
            this.myIgnoreComparisonToZero = ignoreComparisonToZero;
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            super.visitPyBinaryExpression(node);
            PyElementType operator = node.getOperator();
            PyExpression rightExpression = node.getRightExpression();
            if (rightExpression == null || rightExpression instanceof PyBinaryExpression || node.getLeftExpression() instanceof PyBinaryExpression) {
                return;
            }
            if (PyTokenTypes.EQUALITY_OPERATIONS.contains((IElementType)operator) && (PyBinaryExpressionVisitor.operandsEqualTo(node, COMPARISON_LITERALS) || !this.myIgnoreComparisonToZero && PyBinaryExpressionVisitor.operandsEqualTo(node, Collections.singleton("0")))) {
                this.registerProblem(node);
            }
        }

        private static boolean operandsEqualTo(@NotNull PyBinaryExpression expr, @NotNull Collection<String> literals) {
            if (expr == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$PyBinaryExpressionVisitor", "operandsEqualTo"));
            }
            if (literals == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literals", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$PyBinaryExpressionVisitor", "operandsEqualTo"));
            }
            String leftExpressionText = expr.getLeftExpression().getText();
            PyExpression rightExpression = expr.getRightExpression();
            String rightExpressionText = rightExpression != null ? rightExpression.getText() : null;
            for (String literal : literals) {
                if (!literal.equals(leftExpressionText) && !literal.equals(rightExpressionText)) continue;
                return true;
            }
            return false;
        }

        private void registerProblem(PyBinaryExpression binaryExpression) {
            this.registerProblem((PsiElement)binaryExpression, PyBundle.message("INSP.expression.can.be.simplified", new Object[0]), new SimplifyBooleanCheckQuickFix(binaryExpression));
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final boolean myIgnoreComparisonToZero;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, boolean ignoreComparisonToZero) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySimplifyBooleanCheckInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myIgnoreComparisonToZero = ignoreComparisonToZero;
        }

        @Override
        public void visitPyConditionalStatementPart(PyConditionalStatementPart node) {
            super.visitPyConditionalStatementPart(node);
            PyExpression condition = node.getCondition();
            if (condition != null) {
                condition.accept(new PyBinaryExpressionVisitor(this.getHolder(), this.getSession(), this.myIgnoreComparisonToZero));
            }
        }
    }
}

