/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.ResolveProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyShadowingNamesInspection
extends PyInspection {
    @NotNull
    public String getDisplayName() {
        if ("Shadowing names from outer scopes" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyShadowingNamesInspection", "getDisplayName"));
        }
        return "Shadowing names from outer scopes";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyShadowingNamesInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyShadowingNamesInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyShadowingNamesInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor", "visitPyClass"));
            }
            this.processElement(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor", "visitPyFunction"));
            }
            this.processElement(node);
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor", "visitPyNamedParameter"));
            }
            if (node.isSelf()) {
                return;
            }
            this.processElement(node);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor", "visitPyTargetExpression"));
            }
            if (!node.isQualified()) {
                this.processElement(node);
            }
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyShadowingNamesInspection$Visitor", "processElement"));
            }
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            if (owner instanceof PyClass) {
                return;
            }
            String name = element.getName();
            if (name != null) {
                ScopeOwner nextOwner;
                PsiElement problemElement;
                PsiElement identifier = element.getNameIdentifier();
                Object object = problemElement = identifier != null ? identifier : element;
                if ("_".equals(name)) {
                    return;
                }
                if (owner != null && (nextOwner = ScopeUtil.getScopeOwner((PsiElement)owner)) != null) {
                    ResolveProcessor processor = new ResolveProcessor(name);
                    PyResolveUtil.scopeCrawlUp(processor, nextOwner, null, name, null, null);
                    PsiElement resolved = processor.getResult();
                    if (resolved != null) {
                        PyComprehensionElement comprehension = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)resolved, PyComprehensionElement.class);
                        if (comprehension != null && PyUtil.isOwnScopeComprehension(comprehension)) {
                            return;
                        }
                        Scope scope = ControlFlowCache.getScope(owner);
                        if (scope.isGlobal(name) || scope.isNonlocal(name)) {
                            return;
                        }
                        this.registerProblem(problemElement, String.format("Shadows name '%s' from outer scope", name), ProblemHighlightType.WEAK_WARNING, null, new PyRenameElementQuickFix());
                    }
                }
            }
        }
    }
}

