/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.Consumer;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyShadowingBuiltinsInspection
extends PyInspection {
    public List<String> ignoredNames = new ArrayList<String>();

    @NotNull
    public String getDisplayName() {
        if ("Shadowing built-ins" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection", "getDisplayName"));
        }
        return "Shadowing built-ins";
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore built-ins", this.ignoredNames);
        return form.getContentPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session, this.ignoredNames);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredNames;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, @NotNull Collection<String> ignoredNames) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "<init>"));
            }
            if (ignoredNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredNames", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myIgnoredNames = ImmutableSet.copyOf(ignoredNames);
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "visitPyClass"));
            }
            this.processElement(node);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "visitPyFunction"));
            }
            this.processElement(node);
        }

        @Override
        public void visitPyNamedParameter(@NotNull PyNamedParameter node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "visitPyNamedParameter"));
            }
            this.processElement(node);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "visitPyTargetExpression"));
            }
            if (!node.isQualified()) {
                this.processElement(node);
            }
        }

        private void processElement(@NotNull PsiNameIdentifierOwner element) {
            PyBuiltinCache builtinCache;
            PsiElement builtin;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor", "processElement"));
            }
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            if (owner instanceof PyClass) {
                return;
            }
            String name = element.getName();
            if (name != null && !this.myIgnoredNames.contains(name) && (builtin = (builtinCache = PyBuiltinCache.getInstance((PsiElement)element)).getByName(name)) != null && !PyUtil.inSameFile(builtin, (PsiElement)element)) {
                PsiElement identifier = element.getNameIdentifier();
                PsiElement problemElement = identifier != null ? identifier : element;
                this.registerProblem(problemElement, String.format("Shadows built-in name '%s'", name), ProblemHighlightType.WEAK_WARNING, null, new PyRenameElementQuickFix(), new PyIgnoreBuiltinQuickFix(name));
            }
        }

        private static class PyIgnoreBuiltinQuickFix
        implements LocalQuickFix,
        LowPriorityAction {
            @NotNull
            private final String myName;

            private PyIgnoreBuiltinQuickFix(@NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor$PyIgnoreBuiltinQuickFix", "<init>"));
                }
                this.myName = name;
            }

            @NotNull
            public String getName() {
                String string = this.getFamilyName() + " \"" + this.myName + "\"";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor$PyIgnoreBuiltinQuickFix", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                if ("Ignore shadowed built-in name" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor$PyIgnoreBuiltinQuickFix", "getFamilyName"));
                }
                return "Ignore shadowed built-in name";
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor$PyIgnoreBuiltinQuickFix", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyShadowingBuiltinsInspection$Visitor$PyIgnoreBuiltinQuickFix", "applyFix"));
                }
                final PsiElement element = descriptor.getPsiElement();
                if (element != null) {
                    InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
                    profile.modifyProfile((Consumer)new Consumer<ModifiableModel>(){

                        public void consume(ModifiableModel model) {
                            String toolName = PyShadowingBuiltinsInspection.class.getSimpleName();
                            PyShadowingBuiltinsInspection inspection = (PyShadowingBuiltinsInspection)model.getUnwrappedTool(toolName, element);
                            if (inspection != null && !inspection.ignoredNames.contains(PyIgnoreBuiltinQuickFix.this.myName)) {
                                inspection.ignoredNames.add(PyIgnoreBuiltinQuickFix.this.myName);
                            }
                        }
                    });
                }
            }
        }
    }
}

