/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyCompatibilityInspection;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.ReplaceFunctionWithSetLiteralQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySetFunctionToLiteralInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.set.function.to.literal", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static PyElement[] getSetCallArguments(PyCallExpression node) {
        PyExpression argument = node.getArguments()[0];
        if (argument instanceof PyStringLiteralExpression) {
            return PyElement.EMPTY_ARRAY;
        }
        if (argument instanceof PySequenceExpression || argument instanceof PyParenthesizedExpression && ((PyParenthesizedExpression)argument).getContainedExpression() instanceof PyTupleExpression) {
            if (argument instanceof PySequenceExpression) {
                return ((PySequenceExpression)argument).getElements();
            }
            PyExpression tuple = ((PyParenthesizedExpression)argument).getContainedExpression();
            if (tuple instanceof PyTupleExpression) {
                return ((PyTupleExpression)tuple).getElements();
            }
        }
        return PyElement.EMPTY_ARRAY;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PySetFunctionToLiteralInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyElement[] elements;
            PyExpression[] arguments;
            if (!Visitor.isAvailable(node)) {
                return;
            }
            PyExpression callee = node.getCallee();
            if (node.isCalleeText("set") && callee != null && PyBuiltinCache.isInBuiltins(callee) && (arguments = node.getArguments()).length == 1 && (elements = PySetFunctionToLiteralInspection.getSetCallArguments(node)).length != 0) {
                this.registerProblem((PsiElement)node, PyBundle.message("INSP.NAME.set.function.to.literal", new Object[0]), new ReplaceFunctionWithSetLiteralQuickFix());
            }
        }

        private static boolean isAvailable(PyCallExpression node) {
            InspectionProfileEntry inspection;
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(node.getProject()).getInspectionProfile();
            InspectionToolWrapper inspectionTool = profile.getInspectionTool("PyCompatibilityInspection", node.getProject());
            if (inspectionTool != null && (inspection = inspectionTool.getTool()) instanceof PyCompatibilityInspection) {
                JDOMExternalizableStringList versions = ((PyCompatibilityInspection)inspection).ourVersions;
                for (String s : versions) {
                    if (LanguageLevel.fromPythonVersion(s).supportsSetLiterals()) continue;
                    return false;
                }
            }
            return LanguageLevel.forElement((PsiElement)node).supportsSetLiterals();
        }
    }
}

