/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveStatementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReturnStatement;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyReturnFromInitInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.init.return", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyReturnFromInitInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyReturnFromInitInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyReturnFromInitInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyReturnFromInitInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyReturnFromInitInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction function) {
            if (function.getContainingClass() != null && "__init__".equals(function.getName())) {
                ArrayList<PsiElement> offenders = new ArrayList<PsiElement>();
                Visitor.findReturnValueInside(function, offenders);
                for (PsiElement offender : offenders) {
                    this.registerProblem(offender, PyBundle.message("INSP.cant.return.value.from.init", new Object[0]), new PyRemoveStatementQuickFix());
                }
            }
        }

        private static void findReturnValueInside(@NotNull PsiElement node, Collection<PsiElement> offenders) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyReturnFromInitInspection$Visitor", "findReturnValueInside"));
            }
            for (PsiElement child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child instanceof PyFunction || child instanceof PyClass) continue;
                if (child instanceof PyReturnStatement && ((PyReturnStatement)child).getExpression() != null) {
                    offenders.add(child);
                }
                Visitor.findReturnValueInside(child, offenders);
            }
        }
    }
}

