/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.RedundantParenthesesQuickFix;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWhilePart;
import com.jetbrains.python.psi.PyYieldExpression;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyRedundantParenthesesInspection
extends PyInspection {
    public boolean myIgnorePercOperator = false;
    public boolean myIgnoreTupleInReturn = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.redundant.parentheses", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyRedundantParenthesesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyRedundantParenthesesInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyRedundantParenthesesInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session, this.myIgnorePercOperator, this.myIgnoreTupleInReturn);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyRedundantParenthesesInspection", "buildVisitor"));
        }
        return visitor;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Ignore argument of % operator", "myIgnorePercOperator");
        panel.addCheckbox("Ignore tuples", "myIgnoreTupleInReturn");
        return panel;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final boolean myIgnorePercOperator;
        private final boolean myIgnoreTupleInReturn;

        public Visitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session, boolean ignorePercOperator, boolean ignoreTupleInReturn) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyRedundantParenthesesInspection$Visitor", "<init>"));
            }
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyRedundantParenthesesInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myIgnorePercOperator = ignorePercOperator;
            this.myIgnoreTupleInReturn = ignoreTupleInReturn;
        }

        @Override
        public void visitPyParenthesizedExpression(PyParenthesizedExpression node) {
            PyExpression expression = node.getContainedExpression();
            if (node.getText().contains("\n")) {
                return;
            }
            PyYieldExpression yieldExpression = (PyYieldExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PyYieldExpression.class, (boolean)false);
            if (yieldExpression != null) {
                return;
            }
            if (expression instanceof PyTupleExpression && this.myIgnoreTupleInReturn) {
                return;
            }
            if (expression instanceof PyReferenceExpression || expression instanceof PyLiteralExpression) {
                PsiElement parent;
                if (this.myIgnorePercOperator && (parent = node.getParent()) instanceof PyBinaryExpression && ((PyBinaryExpression)parent).getOperator() == PyTokenTypes.PERC) {
                    return;
                }
                if (node.getParent() instanceof PyPrintStatement) {
                    return;
                }
                this.registerProblem((PsiElement)node, "Remove redundant parentheses", new RedundantParenthesesQuickFix());
            } else if (node.getParent() instanceof PyIfPart || node.getParent() instanceof PyWhilePart || node.getParent() instanceof PyReturnStatement) {
                this.registerProblem((PsiElement)node, "Remove redundant parentheses", new RedundantParenthesesQuickFix());
            } else if (expression instanceof PyBinaryExpression) {
                PyBinaryExpression binaryExpression = (PyBinaryExpression)expression;
                if (node.getParent() instanceof PyPrefixExpression) {
                    return;
                }
                if (binaryExpression.getOperator() == PyTokenTypes.AND_KEYWORD || binaryExpression.getOperator() == PyTokenTypes.OR_KEYWORD) {
                    PyExpression leftExpression = binaryExpression.getLeftExpression();
                    PyExpression rightExpression = binaryExpression.getRightExpression();
                    if (leftExpression instanceof PyParenthesizedExpression && rightExpression instanceof PyParenthesizedExpression && !(((PyParenthesizedExpression)leftExpression).getContainedExpression() instanceof PyBinaryExpression) && !(((PyParenthesizedExpression)rightExpression).getContainedExpression() instanceof PyBinaryExpression)) {
                        this.registerProblem((PsiElement)node, "Remove redundant parentheses", new RedundantParenthesesQuickFix());
                    }
                }
            } else if (expression instanceof PyParenthesizedExpression) {
                this.registerProblem((PsiElement)expression, "Remove redundant parentheses", new RedundantParenthesesQuickFix());
            }
        }
    }
}

