/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRedeclarationInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.redeclaration", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyRedeclarationInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyRedeclarationInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyRedeclarationInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyRedeclarationInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            if (!Visitor.isDecorated(node)) {
                this.processElement(node);
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)node);
            if (owner instanceof PyFile || owner instanceof PyClass) {
                this.processElement(node);
            }
        }

        @Override
        public void visitPyClass(PyClass node) {
            if (!Visitor.isDecorated(node)) {
                this.processElement(node);
            }
        }

        private static boolean isConditional(@NotNull PsiElement node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor", "isConditional"));
            }
            return PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{PyIfStatement.class, PyConditionalExpression.class, PyTryExceptStatement.class}) != null;
        }

        private static boolean isDecorated(@NotNull PyDecoratable node) {
            PyDecorator[] decorators;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor", "isDecorated"));
            }
            boolean isDecorated = false;
            PyDecoratorList decoratorList = node.getDecoratorList();
            if (decoratorList != null && (decorators = decoratorList.getDecorators()).length > 0) {
                isDecorated = true;
            }
            return isDecorated;
        }

        private void processElement(final @NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor", "processElement"));
            }
            if (Visitor.isConditional((PsiElement)element)) {
                return;
            }
            final String name = element.getName();
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)element);
            if (owner != null && name != null) {
                int startInstruction;
                PyImportStatement importStatement;
                Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
                Object elementInControlFlow = element;
                if (element instanceof PyTargetExpression && (importStatement = (PyImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatement.class)) != null) {
                    elementInControlFlow = importStatement;
                }
                if ((startInstruction = ControlFlowUtil.findInstructionNumberByElement(instructions, (PsiElement)elementInControlFlow)) < 0) {
                    return;
                }
                final Ref readElementRef = Ref.create(null);
                final Ref writeElementRef = Ref.create(null);
                ControlFlowUtil.iteratePrev(startInstruction, instructions, new Function<Instruction, ControlFlowUtil.Operation>(){

                    public ControlFlowUtil.Operation fun(Instruction instruction) {
                        ReadWriteInstruction rwInstruction;
                        if (instruction instanceof ReadWriteInstruction && instruction.num() != startInstruction && name.equals((rwInstruction = (ReadWriteInstruction)instruction).getName())) {
                            PsiElement originalElement = rwInstruction.getElement();
                            if (originalElement != null) {
                                if (rwInstruction.getAccess().isReadAccess()) {
                                    readElementRef.set((Object)originalElement);
                                }
                                if (rwInstruction.getAccess().isWriteAccess() && originalElement != element) {
                                    writeElementRef.set((Object)originalElement);
                                }
                            }
                            return ControlFlowUtil.Operation.CONTINUE;
                        }
                        return ControlFlowUtil.Operation.NEXT;
                    }
                });
                PsiElement writeElement = (PsiElement)writeElementRef.get();
                if (writeElement != null && readElementRef.get() == null) {
                    PsiElement identifier;
                    ArrayList<PyRenameElementQuickFix> quickFixes = new ArrayList<PyRenameElementQuickFix>();
                    if (Visitor.suggestRename(element, writeElement)) {
                        quickFixes.add(new PyRenameElementQuickFix());
                    }
                    this.registerProblem((PsiElement)((identifier = element.getNameIdentifier()) != null ? identifier : element), PyBundle.message("INSP.redeclared.name", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
                }
            }
        }

        private static boolean suggestRename(@NotNull PsiNameIdentifierOwner element, @NotNull PsiElement originalElement) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor", "suggestRename"));
            }
            if (originalElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/jetbrains/python/inspections/PyRedeclarationInspection$Visitor", "suggestRename"));
            }
            if (element instanceof PyTargetExpression && originalElement instanceof PyTargetExpression) {
                return false;
            }
            return !(element instanceof PyFunction) || !"__init__".equals(element.getName()) || ((PyFunction)element).getContainingClass() == null;
        }
    }
}

