/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyAddPropertyForFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyMakePublicQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyProtectedMemberInspection
extends PyInspection {
    public boolean ignoreTestFunctions = true;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.protected.member.access", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyProtectedMemberInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyProtectedMemberInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyProtectedMemberInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyProtectedMemberInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Ignore test functions", "ignoreTestFunctions");
        return panel;
    }

    private class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyProtectedMemberInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            PyStatement statement = node.getContainingImportStatement();
            if (!(statement instanceof PyFromImportStatement)) {
                return;
            }
            PyReferenceExpression importReferenceExpression = node.getImportReferenceExpression();
            PyReferenceExpression importSource = ((PyFromImportStatement)statement).getImportSource();
            if (importReferenceExpression != null && importSource != null) {
                this.checkReference(importReferenceExpression, importSource);
            }
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            PyExpression qualifier = node.getQualifier();
            if (qualifier == null || "self".equals(qualifier.getText())) {
                return;
            }
            this.checkReference(node, qualifier);
        }

        private void checkReference(@NotNull PyReferenceExpression node, @NotNull PyExpression qualifier) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyProtectedMemberInspection$Visitor", "checkReference"));
            }
            if (qualifier == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/python/inspections/PyProtectedMemberInspection$Visitor", "checkReference"));
            }
            if (this.myTypeEvalContext.getType(qualifier) instanceof PyNamedTupleType) {
                return;
            }
            String name = node.getName();
            ArrayList<Object> quickFixes = new ArrayList<Object>();
            quickFixes.add(new PyRenameElementQuickFix());
            if (name != null && name.startsWith("_") && !name.startsWith("__") && !name.endsWith("__")) {
                PyType type;
                PyClass parentClass;
                PsiPolyVariantReference reference = node.getReference(this.getResolveContext());
                if (reference == null) {
                    return;
                }
                PsiElement resolvedExpression = reference.resolve();
                PyClass resolvedClass = this.getClassOwner(resolvedExpression);
                if (resolvedExpression instanceof PyTargetExpression) {
                    String newName = StringUtil.trimLeading((String)name, (char)'_');
                    if (resolvedClass != null) {
                        String qFixName = resolvedClass.getProperties().containsKey(newName) ? PyBundle.message("QFIX.use.property", new Object[0]) : PyBundle.message("QFIX.add.property", new Object[0]);
                        quickFixes.add(new PyAddPropertyForFieldQuickFix(qFixName));
                        Collection<String> usedNames = PyRefactoringUtil.collectUsedNames(resolvedClass);
                        if (!usedNames.contains(newName)) {
                            quickFixes.add(new PyMakePublicQuickFix());
                        }
                    }
                }
                if ((parentClass = this.getClassOwner((PsiElement)node)) != null) {
                    if (PyTestUtil.isPyTestClass(parentClass) && PyProtectedMemberInspection.this.ignoreTestFunctions) {
                        return;
                    }
                    if (parentClass.isSubclass(resolvedClass)) {
                        return;
                    }
                    PyClass outerClass = this.getClassOwner(parentClass);
                    while (outerClass != null) {
                        if (outerClass.isSubclass(resolvedClass)) {
                            return;
                        }
                        outerClass = this.getClassOwner(outerClass);
                    }
                }
                String bundleKey = (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyModuleType ? "INSP.protected.member.$0.access.module" : "INSP.protected.member.$0.access";
                this.registerProblem((PsiElement)node, PyBundle.message(bundleKey, name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size() - 1]));
            }
        }

        @Nullable
        private PyClass getClassOwner(@Nullable PsiElement element) {
            ScopeOwner owner = ScopeUtil.getScopeOwner(element);
            while (owner != null) {
                if (owner instanceof PyClass) {
                    return (PyClass)owner;
                }
                owner = ScopeUtil.getScopeOwner((PsiElement)owner);
            }
            return null;
        }
    }
}

