/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyUpdatePropertySignatureQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.CallArgumentsMapping;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPropertyDefinitionInspection
extends PyInspection {
    private static final ImmutableList<String> SUFFIXES = ImmutableList.of((Object)"setter", (Object)"deleter");

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.property.definition", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPropertyDefinitionInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPropertyDefinitionInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyPropertyDefinitionInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPropertyDefinitionInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private LanguageLevel myLevel;
        private List<PyClass> myStringClasses;
        private PyFunction myOneParamFunction;
        private PyFunction myTwoParamFunction;

        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
            PsiFile psiFile = session.getFile();
            this.myLevel = LanguageLevel.forElement((PsiElement)psiFile);
            ArrayList<PyClass> stringClasses = new ArrayList<PyClass>(2);
            PyBuiltinCache builtins = PyBuiltinCache.getInstance((PsiElement)psiFile);
            PyClass cls = builtins.getClass("str");
            if (cls != null) {
                stringClasses.add(cls);
            }
            if ((cls = builtins.getClass("unicode")) != null) {
                stringClasses.add(cls);
            }
            this.myStringClasses = stringClasses;
            PyClass objectClass = builtins.getClass("object");
            if (objectClass != null) {
                PyFunction methodDelattr;
                PyFunction methodRepr = objectClass.findMethodByName("__repr__", false);
                if (methodRepr != null) {
                    this.myOneParamFunction = methodRepr;
                }
                if ((methodDelattr = objectClass.findMethodByName("__delattr__", false)) != null) {
                    this.myTwoParamFunction = methodDelattr;
                }
            }
        }

        @Override
        public void visitPyFile(PyFile node) {
            super.visitPyFile(node);
        }

        @Override
        public void visitPyClass(final PyClass node) {
            super.visitPyClass(node);
            node.scanProperties(new Processor<Property>(){

                public boolean process(Property property) {
                    PyTargetExpression target = property.getDefinitionSite();
                    if (target != null) {
                        PyCallExpression call = (PyCallExpression)target.findAssignedValue();
                        assert (call != null) : "Property has a null call assigned to it";
                        PyArgumentList arglist = call.getArgumentList();
                        assert (arglist != null) : "Property call has null arglist";
                        CallArgumentsMapping analysis = arglist.analyzeCall(Visitor.this.getResolveContext());
                        for (Map.Entry<PyExpression, PyNamedParameter> entry : analysis.getPlainMappedParams().entrySet()) {
                            String paramName = entry.getValue().getName();
                            PyExpression argument = PyUtil.peelArgument(entry.getKey());
                            Visitor.this.checkPropertyCallArgument(paramName, argument, node.getContainingFile());
                        }
                    } else {
                        Callable callable = property.getGetter().valueOrNull();
                        if (callable instanceof PyFunction) {
                            Visitor.this.checkGetter(callable, Visitor.getFunctionMarkingElement((PyFunction)callable));
                        }
                    }
                    return false;
                }
            }, false);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private void checkPropertyCallArgument(String paramName, PyExpression argument, PsiFile containingFile) {
            void var4_7;
            assert (argument != null) : "Parameter mapped to null argument";
            Object var4_4 = null;
            if (argument instanceof PyReferenceExpression) {
                PsiPolyVariantReference reference = ((PyReferenceExpression)argument).getReference(this.getResolveContext());
                PsiElement resolved = reference.resolve();
                if (!(resolved instanceof Callable)) {
                    this.reportNonCallableArg(resolved, (PsiElement)argument);
                    return;
                }
                Callable callable = (Callable)resolved;
            } else if (argument instanceof PyLambdaExpression) {
                PyLambdaExpression pyLambdaExpression = (PyLambdaExpression)argument;
            } else if (!"doc".equals(paramName)) {
                this.reportNonCallableArg((PsiElement)argument, (PsiElement)argument);
                return;
            }
            if (var4_7 != null && var4_7.getContainingFile() != containingFile) {
                return;
            }
            if ("fget".equals(paramName)) {
                this.checkGetter((Callable)var4_7, (PsiElement)argument);
                return;
            }
            if ("fset".equals(paramName)) {
                this.checkSetter((Callable)var4_7, (PsiElement)argument);
                return;
            }
            if ("fdel".equals(paramName)) {
                this.checkDeleter((Callable)var4_7, (PsiElement)argument);
                return;
            }
            if (!"doc".equals(paramName)) return;
            PyType type = this.myTypeEvalContext.getType(argument);
            if (type instanceof PyClassType) {
                if (this.myStringClasses.contains(((PyClassType)type).getPyClass())) return;
            }
            this.registerProblem((PsiElement)argument, PyBundle.message("INSP.doc.param.should.be.str", new Object[0]));
        }

        private void reportNonCallableArg(PsiElement resolved, PsiElement element) {
            PyType type;
            Boolean isCallable;
            if (resolved instanceof PySubscriptionExpression || resolved instanceof PyNoneLiteralExpression) {
                return;
            }
            if ("None".equals(element.getText())) {
                return;
            }
            if (resolved instanceof PyTypedElement && (isCallable = PyTypeChecker.isCallable(type = this.myTypeEvalContext.getType((PyTypedElement)resolved))) != null && !isCallable.booleanValue()) {
                this.registerProblem(element, PyBundle.message("INSP.strange.arg.want.callable", new Object[0]));
            }
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyDecoratorList decos;
            PyClass cls;
            super.visitPyFunction(node);
            if (this.myLevel.isAtLeast(LanguageLevel.PYTHON26) && (cls = node.getContainingClass()) != null && (decos = node.getDecoratorList()) != null) {
                String name = node.getName();
                for (PyDecorator deco : decos.getDecorators()) {
                    int suffixIndex;
                    List nameParts;
                    QualifiedName qName = deco.getQualifiedName();
                    if (qName == null || (nameParts = qName.getComponents()).size() != 2 || (suffixIndex = SUFFIXES.indexOf(nameParts.get(1))) < 0) continue;
                    if (Comparing.equal((String)name, (String)((String)nameParts.get(0)))) {
                        PsiElement markable = Visitor.getFunctionMarkingElement(node);
                        if (suffixIndex == 0) {
                            this.checkSetter(node, markable);
                            continue;
                        }
                        this.checkDeleter(node, markable);
                        continue;
                    }
                    this.registerProblem((PsiElement)deco, PyBundle.message("INSP.func.property.name.mismatch", new Object[0]));
                }
            }
        }

        @Nullable
        private static PsiElement getFunctionMarkingElement(PyFunction node) {
            if (node == null) {
                return null;
            }
            ASTNode nameNode = node.getNameNode();
            PyFunction markable = node;
            if (nameNode != null) {
                markable = nameNode.getPsi();
            }
            return markable;
        }

        private void checkGetter(Callable callable, PsiElement beingChecked) {
            if (callable != null) {
                this.checkOneParameter(callable, beingChecked, true);
                this.checkReturnValueAllowed(callable, beingChecked, true, PyBundle.message("INSP.getter.return.smth", new Object[0]));
            }
        }

        private void checkSetter(Callable callable, PsiElement beingChecked) {
            if (callable != null) {
                PyParameterList paramList = callable.getParameterList();
                if (this.myTwoParamFunction != null && !PyUtil.isSignatureCompatibleTo(callable, this.myTwoParamFunction, this.myTypeEvalContext)) {
                    this.registerProblem(beingChecked, PyBundle.message("INSP.setter.signature.advice", new Object[0]), new PyUpdatePropertySignatureQuickFix(true));
                }
                this.checkForSelf(paramList);
                this.checkReturnValueAllowed(callable, beingChecked, false, PyBundle.message("INSP.setter.should.not.return", new Object[0]));
            }
        }

        private void checkDeleter(Callable callable, PsiElement beingChecked) {
            if (callable != null) {
                this.checkOneParameter(callable, beingChecked, false);
                this.checkReturnValueAllowed(callable, beingChecked, false, PyBundle.message("INSP.deleter.should.not.return", new Object[0]));
            }
        }

        private void checkOneParameter(Callable callable, PsiElement beingChecked, boolean isGetter) {
            PyParameterList parameterList = callable.getParameterList();
            if (this.myOneParamFunction != null && !PyUtil.isSignatureCompatibleTo(callable, this.myOneParamFunction, this.myTypeEvalContext)) {
                if (isGetter) {
                    this.registerProblem(beingChecked, PyBundle.message("INSP.getter.signature.advice", new Object[0]), new PyUpdatePropertySignatureQuickFix(false));
                } else {
                    this.registerProblem(beingChecked, PyBundle.message("INSP.deleter.signature.advice", new Object[0]), new PyUpdatePropertySignatureQuickFix(false));
                }
            }
            this.checkForSelf(parameterList);
        }

        private void checkForSelf(PyParameterList paramList) {
            PyParameter[] parameters = paramList.getParameters();
            PyClass cls = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)paramList, PyClass.class);
            if (cls != null && cls.isSubclass("type")) {
                return;
            }
            if (parameters.length > 0 && !"self".equals(parameters[0].getName())) {
                this.registerProblem((PsiElement)parameters[0], PyBundle.message("INSP.accessor.first.param.is.$0", "self"), ProblemHighlightType.WEAK_WARNING, null, new RenameParameterQuickFix("self"));
            }
        }

        private void checkReturnValueAllowed(Callable callable, PsiElement beingChecked, boolean allowed, String message) {
            boolean hasReturns;
            if (callable instanceof PyFunction) {
                PsiElement[] returnStatements = PsiTreeUtil.collectElements((PsiElement)callable, (PsiElementFilter)new PsiElementFilter(){

                    public boolean isAccepted(PsiElement element) {
                        return element instanceof PyReturnStatement && ((PyReturnStatement)element).getExpression() != null || element instanceof PyYieldExpression;
                    }
                });
                hasReturns = returnStatements.length > 0;
            } else {
                PyType type = this.myTypeEvalContext.getReturnType(callable);
                boolean bl = hasReturns = !(type instanceof PyNoneType);
            }
            if (allowed ^ hasReturns) {
                if (allowed && callable instanceof PyFunction) {
                    if (PyUtil.isDecoratedAsAbstract((PyFunction)callable)) {
                        return;
                    }
                    PyStatementList statementList = ((PyFunction)callable).getStatementList();
                    for (PyStatement stmt : statementList.getStatements()) {
                        if (!(stmt instanceof PyRaiseStatement)) continue;
                        return;
                    }
                }
                this.registerProblem(beingChecked, message);
            }
        }
    }
}

