/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyCreatePropertyQuickFix;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.toolbox.Maybe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyPropertyAccessInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.property.access", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPropertyAccessInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPropertyAccessInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyPropertyAccessInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPropertyAccessInspection", "buildVisitor"));
        }
        return visitor;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        private final HashMap<Pair<PyClass, String>, Property> myPropertyCache;

        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPropertyAccessInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myPropertyCache = new HashMap();
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            super.visitPyReferenceExpression(node);
            this.checkExpression(node);
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            this.checkExpression(node);
        }

        private void checkExpression(PyQualifiedExpression node) {
            PyType type;
            PyExpression qualifier = node.getQualifier();
            if (qualifier != null && (type = this.myTypeEvalContext.getType(qualifier)) instanceof PyClassType) {
                PyClass cls = ((PyClassType)type).getPyClass();
                String name = node.getName();
                if (name != null) {
                    Pair key = Pair.create((Object)cls, (Object)name);
                    Property property = this.myPropertyCache.containsKey((Object)key) ? (Property)this.myPropertyCache.get((Object)key) : cls.findProperty(name, true);
                    this.myPropertyCache.put((Object)key, (Object)property);
                    if (property != null) {
                        PsiElement parent;
                        AccessDirection dir = AccessDirection.of(node);
                        this.checkAccessor(node, name, dir, property);
                        if (dir == AccessDirection.READ && (parent = node.getParent()) instanceof PyAugAssignmentStatement && ((PyAugAssignmentStatement)parent).getTarget() == node) {
                            this.checkAccessor(node, name, AccessDirection.WRITE, property);
                        }
                    }
                }
            }
        }

        private void checkAccessor(PyExpression node, String name, AccessDirection dir, Property property) {
            Maybe<Callable> accessor = property.getByDirection(dir);
            if (accessor.isDefined() && accessor.value() == null) {
                String message = dir == AccessDirection.WRITE ? PyBundle.message("INSP.property.$0.cant.be.set", name) : (dir == AccessDirection.DELETE ? PyBundle.message("INSP.property.$0.cant.be.deleted", name) : PyBundle.message("INSP.property.$0.cant.be.read", name));
                this.registerProblem((PsiElement)node, message, new PyCreatePropertyQuickFix(dir));
            }
        }
    }
}

