/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.ide.DataManager;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPep8NamingInspection
extends PyInspection {
    private static final Pattern LOWERCASE_REGEX = Pattern.compile("[_\\p{javaLowerCase}][_\\p{javaLowerCase}0-9]*");
    private static final Pattern UPPERCASE_REGEX = Pattern.compile("[_\\p{javaUpperCase}][_\\p{javaUpperCase}0-9]*");
    private static final Pattern MIXEDCASE_REGEX = Pattern.compile("_?[\\p{javaUpperCase}][\\p{javaLowerCase}\\p{javaUpperCase}0-9]*");
    public boolean ignoreOverriddenFunctions = true;
    public List<String> ignoredBaseClasses = Lists.newArrayList((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"});

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPep8NamingInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyPep8NamingInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPep8NamingInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)new CheckBox("Ignore overridden functions", (InspectionProfileEntry)this, "ignoreOverriddenFunctions"), "North");
        rootPanel.add((Component)new ListEditForm("Excluded base classes", this.ignoredBaseClasses).getContentPanel(), "Center");
        return rootPanel;
    }

    private static class IgnoreBaseClassQuickFix
    implements LocalQuickFix {
        final List<String> myBaseClassNames;

        public IgnoreBaseClassQuickFix(@NotNull PyClass baseClass, @NotNull TypeEvalContext context) {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix", "<init>"));
            }
            this.myBaseClassNames = new ArrayList<String>();
            ContainerUtil.addIfNotNull(this.myBaseClassNames, (Object)baseClass.getQualifiedName());
            for (PyClass ancestor : baseClass.getAncestorClasses(context)) {
                ContainerUtil.addIfNotNull(this.myBaseClassNames, (Object)ancestor.getQualifiedName());
            }
        }

        @NotNull
        public String getName() {
            if ("Ignore method names for descendants of class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix", "getName"));
            }
            return "Ignore method names for descendants of class";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyPep8NamingInspection$IgnoreBaseClassQuickFix", "applyFix"));
            }
            final JBList list = new JBList(this.myBaseClassNames);
            final Runnable updateBlackList = new Runnable(){

                @Override
                public void run() {
                    InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
                    profile.modifyProfile((Consumer)new Consumer<ModifiableModel>(){

                        public void consume(ModifiableModel model) {
                            PyPep8NamingInspection inspection = (PyPep8NamingInspection)model.getUnwrappedTool(PyPep8NamingInspection.class.getSimpleName(), descriptor.getPsiElement());
                            ContainerUtilRt.addIfNotNull(inspection.ignoredBaseClasses, (Object)((String)list.getSelectedValue()));
                        }
                    });
                }
            };
            DataManager.getInstance().getDataContextFromFocus().doWhenDone((Consumer)new Consumer<DataContext>(){

                public void consume(DataContext dataContext) {
                    new PopupChooserBuilder((JList)list).setTitle("Ignore base class").setItemChoosenCallback(updateBlackList).setFilteringEnabled((Function)new Function<Object, String>(){

                        public String fun(Object o) {
                            return (String)o;
                        }
                    }).createPopup().showInBestPositionFor(dataContext);
                }
            });
        }
    }

    public class Visitor
    extends PyInspectionVisitor {
        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            if (holder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPep8NamingInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)true, (Class[])new Class[]{PyClass.class});
            if (function == null) {
                return;
            }
            Scope scope = ControlFlowCache.getScope(function);
            for (PyExpression expression : node.getTargets()) {
                PyExpression qualifier;
                String name = expression.getName();
                if (name == null || scope.isGlobal(name)) continue;
                if (expression instanceof PyTargetExpression && (qualifier = ((PyTargetExpression)expression).getQualifier()) != null) {
                    return;
                }
                if (LOWERCASE_REGEX.matcher(name).matches() || name.startsWith("_")) continue;
                this.registerProblem((PsiElement)expression, "Variable in function should be lowercase", new PyRenameElementQuickFix());
            }
        }

        @Override
        public void visitPyParameter(PyParameter node) {
            String name = node.getName();
            if (name == null) {
                return;
            }
            if (!LOWERCASE_REGEX.matcher(name).matches()) {
                this.registerProblem((PsiElement)node, "Argument name should be lowercase", new PyRenameElementQuickFix());
            }
        }

        @Override
        public void visitPyFunction(PyFunction function) {
            ASTNode nameNode;
            PyClass containingClass = function.getContainingClass();
            if (PyPep8NamingInspection.this.ignoreOverriddenFunctions && this.isOverriddenMethod(function)) {
                return;
            }
            String name = function.getName();
            if (name == null) {
                return;
            }
            if (containingClass != null && (PyUtil.isSpecialName(name) || this.isIgnoredOrHasIgnoredAncestor(containingClass))) {
                return;
            }
            if (!LOWERCASE_REGEX.matcher(name).matches() && (nameNode = function.getNameNode()) != null) {
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyRenameElementQuickFix()});
                if (containingClass != null) {
                    quickFixes.add(new IgnoreBaseClassQuickFix(containingClass, this.myTypeEvalContext));
                }
                this.registerProblem(nameNode.getPsi(), "Function name should be lowercase", quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
            }
        }

        private boolean isOverriddenMethod(@NotNull PyFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/inspections/PyPep8NamingInspection$Visitor", "isOverriddenMethod"));
            }
            return PySuperMethodsSearch.search(function).findFirst() != null;
        }

        private boolean isIgnoredOrHasIgnoredAncestor(@NotNull PyClass pyClass) {
            if (pyClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/inspections/PyPep8NamingInspection$Visitor", "isIgnoredOrHasIgnoredAncestor"));
            }
            HashSet blackList = Sets.newHashSet(PyPep8NamingInspection.this.ignoredBaseClasses);
            if (blackList.contains(pyClass.getQualifiedName())) {
                return true;
            }
            for (PyClassLikeType ancestor : pyClass.getAncestorTypes(this.myTypeEvalContext)) {
                if (ancestor == null || !blackList.contains(ancestor.getClassQName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public void visitPyClass(PyClass node) {
            ASTNode nameNode;
            String name = node.getName();
            if (name == null) {
                return;
            }
            if (!MIXEDCASE_REGEX.matcher(name).matches() && (nameNode = node.getNameNode()) != null) {
                this.registerProblem(nameNode.getPsi(), "Class names should use CamelCase convention", new PyRenameElementQuickFix());
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement node) {
            String asName = node.getAsName();
            QualifiedName importedQName = node.getImportedQName();
            if (importedQName == null) {
                return;
            }
            String name = importedQName.getLastComponent();
            if (asName == null || name == null) {
                return;
            }
            if (UPPERCASE_REGEX.matcher(name).matches()) {
                if (!UPPERCASE_REGEX.matcher(asName).matches()) {
                    this.registerProblem((PsiElement)node.getAsNameElement(), "Constant variable imported as non constant", new PyRenameElementQuickFix());
                }
            } else if (LOWERCASE_REGEX.matcher(name).matches()) {
                if (!LOWERCASE_REGEX.matcher(asName).matches()) {
                    this.registerProblem((PsiElement)node.getAsNameElement(), "Lowercase variable imported as non lowercase", new PyRenameElementQuickFix());
                }
            } else if (LOWERCASE_REGEX.matcher(asName).matches()) {
                this.registerProblem((PsiElement)node.getAsNameElement(), "CamelCase variable imported as lowercase", new PyRenameElementQuickFix());
            } else if (UPPERCASE_REGEX.matcher(asName).matches()) {
                this.registerProblem((PsiElement)node.getAsNameElement(), "CamelCase variable imported as constant", new PyRenameElementQuickFix());
            }
        }
    }
}

