/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.Function;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageRequirementsInspection
extends PyInspection {
    public JDOMExternalizableStringList ignoredPackages = new JDOMExternalizableStringList();

    @NotNull
    public String getDisplayName() {
        if ("Package requirements" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "getDisplayName"));
        }
        return "Package requirements";
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore packages", (List)this.ignoredPackages);
        return form.getContentPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session, (Collection<String>)this.ignoredPackages);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "buildVisitor"));
        }
        return visitor;
    }

    @Nullable
    public static PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "getInstance"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(element.getProject()).getInspectionProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        return (PyPackageRequirementsInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Nullable
    private static Set<PyRequirement> getTransitiveRequirements(@NotNull Sdk sdk, @NotNull Collection<PyRequirement> requirements, @NotNull Set<PyPackage> visited) {
        List<PyPackage> packages;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "getTransitiveRequirements"));
        }
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "getTransitiveRequirements"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "getTransitiveRequirements"));
        }
        HashSet<PyRequirement> results = new HashSet<PyRequirement>(requirements);
        try {
            packages = PyPackageManager.getInstance(sdk).getPackages(PySdkUtil.isRemote(sdk));
        }
        catch (ExecutionException e) {
            return null;
        }
        if (packages == null) {
            return null;
        }
        for (PyRequirement req : requirements) {
            PyPackage pkg = req.match(packages);
            if (pkg == null || visited.contains(pkg)) continue;
            visited.add(pkg);
            Set<PyRequirement> transitive = PyPackageRequirementsInspection.getTransitiveRequirements(sdk, pkg.getRequirements(), visited);
            if (transitive == null) {
                return null;
            }
            results.addAll(transitive);
        }
        return results;
    }

    @NotNull
    private static String requirementsToString(@NotNull List<PyRequirement> requirements) {
        if (requirements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requirements", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "requirementsToString"));
        }
        String string = StringUtil.join(requirements, (Function)new Function<PyRequirement, String>(){

            public String fun(PyRequirement requirement) {
                return String.format("'%s'", requirement.toString());
            }
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "requirementsToString"));
        }
        return string;
    }

    @Nullable
    private static List<PyRequirement> findUnsatisfiedRequirements(@NotNull Module module, @NotNull Sdk sdk, @NotNull Set<String> ignoredPackages) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "findUnsatisfiedRequirements"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "findUnsatisfiedRequirements"));
        }
        if (ignoredPackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ignoredPackages", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "findUnsatisfiedRequirements"));
        }
        PyPackageManager manager = PyPackageManager.getInstance(sdk);
        List<PyRequirement> requirements = manager.getRequirements(module);
        if (requirements != null) {
            List<PyPackage> packages;
            try {
                packages = manager.getPackages(PySdkUtil.isRemote(sdk));
            }
            catch (ExecutionException e) {
                return null;
            }
            if (packages == null) {
                return null;
            }
            ArrayList<PyRequirement> unsatisfied = new ArrayList<PyRequirement>();
            for (PyRequirement req : requirements) {
                if (ignoredPackages.contains(req.getName()) || req.match(packages) != null) continue;
                unsatisfied.add(req);
            }
            return unsatisfied;
        }
        return null;
    }

    private static void setRunningPackagingTasks(@NotNull Module module, boolean value) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "setRunningPackagingTasks"));
        }
        module.putUserData(PyPackageManager.RUNNING_PACKAGING_TASKS, (Object)value);
    }

    private static boolean isRunningPackagingTasks(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection", "isRunningPackagingTasks"));
        }
        Boolean value = (Boolean)module.getUserData(PyPackageManager.RUNNING_PACKAGING_TASKS);
        return value != null && value != false;
    }

    private static class AddToRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final String myPackageName;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        @NotNull
        private Module myModule;

        private AddToRequirementsFix(@NotNull Module module, @NotNull String packageName, @NotNull LanguageLevel languageLevel) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "<init>"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "<init>"));
            }
            if (languageLevel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "<init>"));
            }
            this.myPackageName = packageName;
            this.myLanguageLevel = languageLevel;
            this.myModule = module;
        }

        @Nullable
        private PyArgumentList findSetupArgumentList() {
            PyCallExpression setupCall;
            PyFile setupPy = PyPackageUtil.findSetupPy(this.myModule);
            if (setupPy != null && (setupCall = PyPackageUtil.findSetupCall(setupPy)) != null) {
                return setupCall.getArgumentList();
            }
            return null;
        }

        @NotNull
        public String getName() {
            VirtualFile requirementsTxt = PyPackageUtil.findRequirementsTxt(this.myModule);
            PyListLiteralExpression setupPyRequires = PyPackageUtil.findSetupPyRequires(this.myModule);
            String target = requirementsTxt != null ? requirementsTxt.getName() : (setupPyRequires != null || this.findSetupArgumentList() != null ? "setup.py" : "project requirements");
            String string = String.format("Add requirement '%s' to %s", this.myPackageName, target);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix", "applyFix"));
            }
            final VirtualFile requirementsTxt = PyPackageUtil.findRequirementsTxt(this.myModule);
            final PyListLiteralExpression setupPyRequires = PyPackageUtil.findSetupPyRequires(this.myModule);
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            if (requirementsTxt != null) {
                                Document document;
                                if (requirementsTxt.isWritable() && (document = FileDocumentManager.getInstance().getDocument(requirementsTxt)) != null) {
                                    document.insertString(0, (CharSequence)(AddToRequirementsFix.this.myPackageName + "\n"));
                                }
                            } else {
                                PyKeywordArgument requiresArg;
                                PyElementGenerator generator = PyElementGenerator.getInstance(project);
                                PyArgumentList argumentList = AddToRequirementsFix.this.findSetupArgumentList();
                                if (setupPyRequires != null) {
                                    if (setupPyRequires.getContainingFile().isWritable()) {
                                        String text = String.format("'%s'", AddToRequirementsFix.this.myPackageName);
                                        PyExpression generated = generator.createExpressionFromText(AddToRequirementsFix.this.myLanguageLevel, text);
                                        setupPyRequires.add((PsiElement)generated);
                                    }
                                } else if (argumentList != null && (requiresArg = this.generateRequiresKwarg(generator)) != null) {
                                    argumentList.addArgument(requiresArg);
                                }
                            }
                        }

                        @Nullable
                        private PyKeywordArgument generateRequiresKwarg(PyElementGenerator generator) {
                            String text = String.format("foo(requires=['%s'])", AddToRequirementsFix.this.myPackageName);
                            PyExpression generated = generator.createExpressionFromText(AddToRequirementsFix.this.myLanguageLevel, text);
                            PyKeywordArgument installRequiresArg = null;
                            if (generated instanceof PyCallExpression) {
                                PyCallExpression foo = (PyCallExpression)generated;
                                for (PyExpression arg : foo.getArguments()) {
                                    PyKeywordArgument kwarg;
                                    if (!(arg instanceof PyKeywordArgument) || !"requires".equals((kwarg = (PyKeywordArgument)arg).getKeyword())) continue;
                                    installRequiresArg = kwarg;
                                }
                            }
                            return installRequiresArg;
                        }
                    });
                }
            }, this.getName(), null);
        }
    }

    private static class IgnoreRequirementFix
    implements LocalQuickFix {
        @NotNull
        private final Set<String> myPackageNames;

        public IgnoreRequirementFix(@NotNull Set<String> packageNames) {
            if (packageNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNames", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix", "<init>"));
            }
            this.myPackageNames = packageNames;
        }

        @NotNull
        public String getName() {
            boolean plural = this.myPackageNames.size() > 1;
            String string = String.format("Ignore requirement%s", plural ? "s" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PyPackageRequirementsInspection inspection;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element != null && (inspection = PyPackageRequirementsInspection.getInstance(element)) != null) {
                JDOMExternalizableStringList ignoredPackages = inspection.ignoredPackages;
                boolean changed = false;
                for (String name : this.myPackageNames) {
                    if (ignoredPackages.contains((Object)name)) continue;
                    ignoredPackages.add((Object)name);
                    changed = true;
                }
                if (changed) {
                    InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
                    InspectionProfileManager.getInstance().fireProfileChanged((Profile)profile);
                }
            }
        }
    }

    private static class UIListener
    implements PyPackageManagerUI.Listener {
        private final Module myModule;

        public UIListener(Module module) {
            this.myModule = module;
        }

        @Override
        public void started() {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, true);
        }

        @Override
        public void finished(List<ExecutionException> exceptions) {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, false);
        }
    }

    public static class PyInstallRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private String myName;
        @NotNull
        private final Module myModule;
        @NotNull
        private Sdk mySdk;
        @NotNull
        private final List<PyRequirement> myUnsatisfied;

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied) {
            boolean plural;
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "<init>"));
            }
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "<init>"));
            }
            if (unsatisfied == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsatisfied", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "<init>"));
            }
            boolean bl = plural = unsatisfied.size() > 1;
            this.myName = name != null ? name : String.format("Install requirement%s", plural ? "s" : "");
            this.myModule = module;
            this.mySdk = sdk;
            this.myUnsatisfied = unsatisfied;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PyChooseRequirementsDialog dialog;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix", "applyFix"));
            }
            boolean installManagement = false;
            PyPackageManager manager = PyPackageManager.getInstance(this.mySdk);
            boolean hasManagement = false;
            try {
                hasManagement = manager.hasManagement(false);
            }
            catch (ExecutionException ignored) {
                // empty catch block
            }
            if (!hasManagement) {
                int result = Messages.showYesNoDialog((Project)project, (String)"Python packaging tools are required for installing packages. Do you want to install 'pip' and 'setuptools' for your interpreter?", (String)"Install Python Packaging Tools", (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    installManagement = true;
                } else {
                    return;
                }
            }
            final List<PyRequirement> chosen = this.myUnsatisfied.size() > 1 ? ((dialog = new PyChooseRequirementsDialog(project, this.myUnsatisfied)).showAndGet() ? dialog.getMarkedElements() : Collections.emptyList()) : this.myUnsatisfied;
            if (chosen.isEmpty()) {
                return;
            }
            if (installManagement) {
                PyPackageManagerUI ui = new PyPackageManagerUI(project, this.mySdk, new UIListener(this.myModule){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            PyInstallRequirementsFix.this.installRequirements(project, chosen);
                        }
                    }
                });
                ui.installManagement();
            } else {
                this.installRequirements(project, chosen);
            }
        }

        private void installRequirements(Project project, List<PyRequirement> requirements) {
            PyPackageManagerUI ui = new PyPackageManagerUI(project, this.mySdk, new UIListener(this.myModule));
            ui.install(requirements, Collections.<String>emptyList());
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredPackages;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session, Collection<String> ignoredPackages) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myIgnoredPackages = ImmutableSet.copyOf(ignoredPackages);
        }

        @Override
        public void visitPyFile(PyFile node) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            if (module != null) {
                List unsatisfied;
                if (PyPackageRequirementsInspection.isRunningPackagingTasks(module)) {
                    return;
                }
                Sdk sdk = PythonSdkType.findPythonSdk(module);
                if (sdk != null && (unsatisfied = PyPackageRequirementsInspection.findUnsatisfiedRequirements(module, sdk, this.myIgnoredPackages)) != null && !unsatisfied.isEmpty()) {
                    boolean plural = unsatisfied.size() > 1;
                    String msg = String.format("Package requirement%s %s %s not satisfied", plural ? "s" : "", PyPackageRequirementsInspection.requirementsToString(unsatisfied), plural ? "are" : "is");
                    HashSet<String> unsatisfiedNames = new HashSet<String>();
                    for (PyRequirement req : unsatisfied) {
                        unsatisfiedNames.add(req.getName());
                    }
                    ArrayList<Object> quickFixes = new ArrayList<Object>();
                    quickFixes.add(new PyInstallRequirementsFix(null, module, sdk, unsatisfied));
                    quickFixes.add(new IgnoreRequirementFix(unsatisfiedNames));
                    this.registerProblem((PsiElement)node, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
                }
            }
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PyReferenceExpression expr = node.getImportSource();
            if (expr != null) {
                this.checkPackageNameInRequirements(expr);
            }
        }

        @Override
        public void visitPyImportStatement(PyImportStatement node) {
            for (PyImportElement element : node.getImportElements()) {
                PyReferenceExpression expr = element.getImportReferenceExpression();
                if (expr == null) continue;
                this.checkPackageNameInRequirements(expr);
            }
        }

        private void checkPackageNameInRequirements(@NotNull PyQualifiedExpression importedExpression) {
            String packageName;
            if (importedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedExpression", "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor", "checkPackageNameInRequirements"));
            }
            for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                if (!extension.ignorePackageNameInRequirements(importedExpression)) continue;
                return;
            }
            PyExpression packageReferenceExpression = PyPsiUtils.getFirstQualifier(importedExpression);
            if (packageReferenceExpression != null && (packageName = packageReferenceExpression.getName()) != null && !this.myIgnoredPackages.contains(packageName)) {
                Sdk sdk;
                if (!ApplicationManager.getApplication().isUnitTestMode() && !PyPIPackageUtil.INSTANCE.isInPyPI(packageName)) {
                    return;
                }
                Collection<String> stdlibPackages = PyStdlibUtil.getPackages();
                if (stdlibPackages != null && stdlibPackages.contains(packageName)) {
                    return;
                }
                if ("setuptools".equals(packageName)) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)packageReferenceExpression);
                if (module != null && (sdk = PythonSdkType.findPythonSdk(module)) != null) {
                    VirtualFile virtualFile;
                    PsiFile file;
                    PsiElement element;
                    PyPackageManager manager = PyPackageManager.getInstance(sdk);
                    Collection<PyRequirement> requirements = manager.getRequirements(module);
                    if (requirements != null) {
                        requirements = PyPackageRequirementsInspection.getTransitiveRequirements(sdk, requirements, new HashSet());
                    }
                    if (requirements == null) {
                        return;
                    }
                    for (PyRequirement req : requirements) {
                        if (!packageName.equalsIgnoreCase(req.getName())) continue;
                        return;
                    }
                    PsiReference reference = packageReferenceExpression.getReference();
                    if (reference != null && (element = reference.resolve()) != null && (file = element.getContainingFile()) != null && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)(virtualFile = file.getVirtualFile()), (boolean)false)) {
                        return;
                    }
                    ArrayList<Object> quickFixes = new ArrayList<Object>();
                    quickFixes.add(new AddToRequirementsFix(module, packageName, LanguageLevel.forElement((PsiElement)importedExpression)));
                    quickFixes.add(new IgnoreRequirementFix(Collections.singleton(packageName)));
                    this.registerProblem((PsiElement)packageReferenceExpression, String.format("Package '%s' is not listed in project requirements", packageName), ProblemHighlightType.WEAK_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
                }
            }
        }
    }
}

