/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.Lists;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyChangeBaseClassQuickFix;
import com.jetbrains.python.inspections.quickfix.PyConvertToNewStyleQuickFix;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyOldStyleClassesInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.oldstyle.class", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyOldStyleClassesInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyOldStyleClassesInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyOldStyleClassesInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyOldStyleClassesInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyOldStyleClassesInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        @Override
        public void visitPyClass(PyClass node) {
            List<PyClassLikeType> expressions = node.getSuperClassTypes(this.myTypeEvalContext);
            ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyConvertToNewStyleQuickFix()});
            if (!expressions.isEmpty()) {
                quickFixes.add(new PyChangeBaseClassQuickFix());
            }
            if (!node.isNewStyleClass()) {
                for (PyTargetExpression attr : node.getClassAttributes()) {
                    if (!"__slots__".equals(attr.getName())) continue;
                    this.registerProblem((PsiElement)attr, "Old-style class contains __slots__ definition", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
                }
                for (PyFunction attr : node.getMethods(false)) {
                    if (!"__getattribute__".equals(attr.getName())) continue;
                    ASTNode nameNode = attr.getNameNode();
                    assert (nameNode != null);
                    this.registerProblem(nameNode.getPsi(), "Old-style class contains __getattribute__ definition", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
                }
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyClass klass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            if (klass != null && !klass.isNewStyleClass()) {
                PyExpression callee;
                List<PyClassLikeType> types = klass.getSuperClassTypes(this.myTypeEvalContext);
                for (PyClassLikeType type : types) {
                    if (type == null) {
                        return;
                    }
                    String qName = type.getClassQName();
                    if (qName != null && qName.contains("PyQt")) {
                        return;
                    }
                    if (type instanceof PyClassType) continue;
                    return;
                }
                ArrayList quickFixes = Lists.newArrayList((Object[])new LocalQuickFix[]{new PyConvertToNewStyleQuickFix()});
                if (!types.isEmpty()) {
                    quickFixes.add(new PyChangeBaseClassQuickFix());
                }
                if (PyUtil.isSuperCall(node) && (callee = node.getCallee()) != null) {
                    this.registerProblem((PsiElement)callee, "Old-style class contains call for super method", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(quickFixes.toArray(new LocalQuickFix[quickFixes.size()])));
                }
            }
        }
    }
}

