/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyRemoveAssignmentQuickFix;
import com.jetbrains.python.psi.Callable;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.sdk.PySdkUtil;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNoneFunctionAssignmentInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.none.function.assignment", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Map<PyFunction, Boolean> myHasInheritors;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection$Visitor", "<init>"));
            }
            super(holder, session);
            this.myHasInheritors = new HashMap();
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            PyExpression value = node.getAssignedValue();
            if (value instanceof PyCallExpression) {
                PyTypeChecker.AnalyzeCallResults analyzeCallResults;
                PyType type = this.myTypeEvalContext.getType(value);
                PyExpression callee = ((PyCallExpression)value).getCallee();
                if (type instanceof PyNoneType && callee != null && (analyzeCallResults = PyTypeChecker.analyzeCall((PyCallExpression)value, this.myTypeEvalContext)) != null) {
                    PyFunction function;
                    Callable callable = analyzeCallResults.getCallable();
                    if (PySdkUtil.isElementInSkeletons((PsiElement)callable)) {
                        return;
                    }
                    if (callable instanceof PyFunction && (this.hasInheritors(function = (PyFunction)callable) || PyUtil.hasCustomDecorators(function))) {
                        return;
                    }
                    this.registerProblem((PsiElement)node, PyBundle.message("INSP.none.function.assignment", callee.getName()), new PyRemoveAssignmentQuickFix());
                }
            }
        }

        private boolean hasInheritors(@NotNull PyFunction function) {
            if (function == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/jetbrains/python/inspections/PyNoneFunctionAssignmentInspection$Visitor", "hasInheritors"));
            }
            Boolean cached = this.myHasInheritors.get(function);
            if (cached != null) {
                return cached;
            }
            boolean result = PyOverridingMethodsSearch.search(function, true).findFirst() != null;
            this.myHasInheritors.put(function, result);
            return result;
        }
    }
}

