/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.inspections.PyEncodingUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddEncodingQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PyNonAsciiCharInspection
extends PyInspection {
    public String myDefaultEncoding = "utf-8";
    public int myEncodingFormatIndex = 0;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.non.ascii", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyNonAsciiCharInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/inspections/PyNonAsciiCharInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyNonAsciiCharInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder, session);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/inspections/PyNonAsciiCharInspection", "buildVisitor"));
        }
        return visitor;
    }

    public JComponent createOptionsPanel() {
        JComboBox<String> defaultEncoding = new JComboBox<String>(PyEncodingUtil.POSSIBLE_ENCODINGS);
        defaultEncoding.setSelectedItem(this.myDefaultEncoding);
        defaultEncoding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyNonAsciiCharInspection.this.myDefaultEncoding = (String)cb.getSelectedItem();
            }
        });
        JComboBox<String> encodingFormat = new JComboBox<String>(PyEncodingUtil.ENCODING_FORMAT);
        encodingFormat.setSelectedIndex(this.myEncodingFormatIndex);
        encodingFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                PyNonAsciiCharInspection.this.myEncodingFormatIndex = cb.getSelectedIndex();
            }
        });
        return PyEncodingUtil.createEncodingOptionsPanel(defaultEncoding, encodingFormat);
    }

    private class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyNonAsciiCharInspection$Visitor", "<init>"));
            }
            super(holder, session);
        }

        public void visitComment(PsiComment node) {
            this.checkString((PsiElement)node, node.getText());
        }

        private void checkString(PsiElement node, String value) {
            if (LanguageLevel.forElement(node).isPy3K()) {
                return;
            }
            PsiFile file = node.getContainingFile();
            if (file == null) {
                return;
            }
            String charsetString = PythonFileType.getCharsetFromEncodingDeclaration(file);
            boolean hasNonAscii = false;
            CharsetEncoder asciiEncoder = Charset.forName("US-ASCII").newEncoder();
            int length = value.length();
            char c = '\u0000';
            for (int i = 0; i < length; ++i) {
                c = value.charAt(i);
                if (asciiEncoder.canEncode(c)) continue;
                hasNonAscii = true;
                break;
            }
            if (hasNonAscii && charsetString == null) {
                this.registerProblem(node, "Non-ASCII character " + c + " in file, but no encoding declared", new AddEncodingQuickFix(PyNonAsciiCharInspection.this.myDefaultEncoding, PyNonAsciiCharInspection.this.myEncodingFormatIndex));
            }
        }

        @Override
        public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
            this.checkString(node, node.getText());
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            this.checkString((PsiElement)node, node.getText());
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            this.checkString((PsiElement)node, node.getText());
        }
    }
}

